﻿---
title: Troubleshoot indicators of compromise
description: If indicator data is not appearing in the Indicators table after you installed a threat intelligence integration: Verify that the index storing indicator...
url: https://www.elastic.co/docs/troubleshoot/security/indicators-of-compromise
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Troubleshoot indicators of compromise
If indicator data is not appearing in the Indicators table after you installed a threat intelligence integration:
- Verify that the index storing indicator documents is included in the [default Elastic Security indices](/docs/solutions/security/get-started/configure-advanced-settings#update-sec-indices) (`securitySolution:defaultIndex`). The index storing indicator documents will differ based on the way you’re collecting indicator data:
  - **Elastic Agent integrations** - `logs_ti*`
- **Filebeat integrations** - `filebeat-*`
- Ensure the indicator data you’re ingesting is mapped to [Elastic Common Schema (ECS)](https://www.elastic.co/docs/reference/ecs).

<note>
  These troubleshooting steps also apply to the [Threat Intelligence view](https://www.elastic.co/docs/solutions/security/get-started/enable-threat-intelligence-integrations).
</note>