﻿---
title: Troubleshoot Synthetics
description: For debugging synthetic tests locally, you can set an environment variable, DEBUG=synthetics, to capture Synthetics agent logs when using the Synthetics...
url: https://www.elastic.co/docs/troubleshoot/observability/troubleshooting-synthetics
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Troubleshoot Synthetics
## Local debugging

For debugging synthetic tests locally, you can set an environment variable, `DEBUG=synthetics`, to capture Synthetics agent logs when using the [Synthetics CLI](https://www.elastic.co/docs/solutions/observability/synthetics/cli).

## Common issues


### Monitors stopped running after upgrading to 8.8.0 or above

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

Synthetic monitors will stop running if you have gone through this workflow:
1. Enabled Monitor Management (in the Uptime app) prior to 8.6.0.
2. Created a synthetic monitor that is configured to run on Elastic’s global managed infrastructure.
3. Upgraded to 8.8.0 or above.

This happens because the permissions granted by clicking **Enable Monitor Management** in versions prior to 8.6.0 are not sufficient in versions 8.8.0 and above.
To fix this, a user with [admin permissions](https://www.elastic.co/docs/solutions/observability/synthetics/setup-role) needs to visit the Synthetics app in Kibana. In 8.8.0 and above, the equivalent of "enabling monitor management" happens automatically in the background when a user with [admin permissions](https://www.elastic.co/docs/solutions/observability/synthetics/setup-role) visits the Synthetics app.
If a user *without* [admin permissions](https://www.elastic.co/docs/solutions/observability/synthetics/setup-role) visits the Synthetics app before an admin has visited it, the user will see a note that says "Only administrators can enable this feature". That note will persist until an admin user visits the Synthetics app.

### No results from a monitor configured to run on a Private Location

If you have created a Private Location and configured a monitor to run on that Private Location, but don’t see any results for that monitor in the Synthetics app, make sure there is an agent configured to run against the agent policy.
<note>
  If you attempt to assign an agent policy to a Private Location *before* configuring an agent to run against the agent policy, you will see a note in the Synthetics app UI that the selected agent policy has no agents.
</note>

When creating a Private Location, you have to:
<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    1. [Set up Elastic Agent](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-fleet-agent).
    2. [Connect Fleet to your Observability project](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-connect) and enroll an Elastic Agent in Fleet.
    3. [Add a Private Location](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-add) in the Synthetics UI.
  </applies-item>

  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    1. [Set up Fleet Server and Elastic Agent](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-fleet-agent).
    2. [Connect Fleet to the Elastic Stack](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-connect) and enroll an Elastic Agent in Fleet.
    3. [Add a Private Location](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-add) in the Synthetics app.
  </applies-item>
</applies-switch>

If you do not complete the second item, no agents will be configured to run against the agent policy, and any monitors configured to run on that Private Location won’t be able to run so there will be no results in the Synthetics app.
To fix this, make sure there is an agent configured to run against the agent policy.

### No results from a monitor

If you have configured a monitor but don’t see any results for that monitor in the Synthetics app, whether running them from Elastic’s global managed testing infrastructure or from Private Locations, ensure Synthetics has a direct connection to Elasticsearch.
Do not configure any ingest pipelines or output via Logstash as this will prevent Synthetics from working properly and is not [supported](https://www.elastic.co/docs/solutions/observability/synthetics/support-matrix).

### Browser monitor configured to run on a Private Location not running to schedule

If you have browser monitors configured to run on a Private Location but notice one or more of them are not running as scheduled, this could be because:
- The time it takes for your monitor to run is longer than the frequency you have set
- There may be too many monitors trying to run concurrently, causing some of them to skip their scheduled run

You may also see a message in the logs such as `2 tasks have missed their schedule deadlines by more than 1 second in the last 15s`. These will be visible from inside the Agent diagnostic ZIP file, and the numbers and time periods may be different in your logs.
Start by identifying the cause of the issue. First, check if the time it takes the monitor to run is less than the scheduled frequency:
1. Go to the Synthetics app.
2. Click the monitor, then click **Go to monitor**.
3. Go to the [Overview tab](/docs/solutions/observability/synthetics/analyze-data#synthetics-analyze-individual-monitors-overview) to see the *Avg. duration*. You can also view the duration for individual runs in the [History tab](/docs/solutions/observability/synthetics/analyze-data#synthetics-analyze-individual-monitors-history).
4. Compare the duration to the scheduled frequency. If the duration is *greater than* the scheduled frequency, for example if the monitor that takes 90 seconds to run and its scheduled frequency is 1 minute, the next scheduled run will not occur because the current one is still running so you may see results for every other scheduled run.
   To fix this, you can either:
   - Change the frequency so the monitor runs less often.
- Refactor the monitor so it can run in a shorter amount of time.

If the duration is *less than* the scheduled frequency or the suggestion above does not fix the issue, then there may be too many browser monitors attempting to run on the Private Location. Due to the additional hardware overhead of running browser monitors, we limit each Private Location to only run two browser monitors at the same time. Depending on how many browser monitors you have configured to run on the Private Location and their schedule, the Private Location may not be able to run them all because it would require more than two browser tests to be running simultaneously.
To fix this issue, you can either:
- Increase the number of concurrent browser monitors allowed (as described in [Scaling Private Locations](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-scaling)), paying attention to the scaling and hardware requirements documented.
- Create multiple Private Locations and spread your browser monitors across them more evenly (effectively horizontally scaling your Private Locations).


### No locations are available

When using Elastic Cloud, if there are no options available in the *Locations* dropdown when you try to create a monitor in the Synthetics app *or* if no locations are listed when using the [`location` command](/docs/solutions/observability/synthetics/cli#elastic-synthetics-locations-command), it might be because you do not have permission to use Elastic managed locations *and* there are no [Private Locations](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#monitor-via-private-agent) available yet.
There are a few ways to fix this:
<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    - If you have [Editor](https://www.elastic.co/docs/solutions/observability/synthetics/grant-access-to-secured-resources) access, you can [create a new Private Location](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#monitor-via-private-agent). Then try creating the monitor again.
    - If you do *not* have the right privileges to create a Private Location, you can ask an [Admin](https://www.elastic.co/docs/solutions/observability/synthetics/grant-access-to-secured-resources) to create a Private Location or give you the necessary privileges so you can [create a new Private Location](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#monitor-via-private-agent). Then try creating the monitor again.
  </applies-item>

  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    - If you have [write access](https://www.elastic.co/docs/solutions/observability/synthetics/writer-role) including the privileges for [creating new Private Locations](/docs/solutions/observability/synthetics/writer-role#synthetics-role-write-private-locations), you can [create a new Private Location](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#monitor-via-private-agent). Then try creating the monitor again.
    - If you do *not* have the right privileges to create a Private Location, you can ask someone with the [necessary privileges](/docs/solutions/observability/synthetics/writer-role#synthetics-role-write-private-locations) to create a Private Location or ask an administrator with a [setup role](https://www.elastic.co/docs/solutions/observability/synthetics/setup-role) to give you the necessary privileges and [create a new Private Location](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#monitor-via-private-agent). Then try creating the monitor again.
    - If you want to create a monitor to run on Elastic’s global managed infrastructure, ask an administrator with a [setup role](https://www.elastic.co/docs/solutions/observability/synthetics/setup-role) to update [`Synthetics and Uptime` sub-feature privileges](/docs/solutions/observability/synthetics/writer-role#disable-managed-locations) for the role you’re currently assigned. Then try creating the monitor again.
  </applies-item>
</applies-switch>


### You do not have permission to use Elastic managed locations

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

If you try to create or edit a monitor hosted on Elastic’s global managed infrastructure but see a note that you do not have permission to use Elastic managed locations, an administrator has restricted the use of public locations.
To fix this you can either:
- Ask an administrator with a [setup role](https://www.elastic.co/docs/solutions/observability/synthetics/setup-role) to update [`Synthetics and Uptime` sub-feature privileges](/docs/solutions/observability/synthetics/writer-role#disable-managed-locations) for the role you’re currently assigned or assign you a role that allows using Elastic’s global managed infrastructure.
- Use a [Private Location](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#monitor-via-private-agent).


## Get help


### Elastic Support

We offer a support experience unlike any other. Our team of professionals *speak human and code* and love making your day. [Learn more about subscriptions](https://www.elastic.co/subscriptions).

### Discussion forum

For other questions and feature requests, visit our [discussion forum](https://discuss.elastic.co//c/observability/synthetics/75).