﻿---
title: Troubleshoot Uptime mapping issues
description: There are situations in which Heartbeat data can be indexed without the correct mappings applied. These situations cannot occur with the Elastic Agent...
url: https://www.elastic.co/docs/troubleshoot/observability/troubleshoot-mapping-issues
products:
  - Elastic Observability
applies_to:
  - Elastic Stack: Deprecated since 8.15
---

# Troubleshoot Uptime mapping issues
## Mapping issues

There are situations in which Heartbeat data can be indexed without the correct mappings applied. These situations cannot occur with the Elastic Agent configured via Fleet, only with standalone Heartbeat or Elastic Agent running in standalone mode. This can occur when the underlying `heartbeat-VERSION` ILM alias is deleted manually or when Heartbeat writes data through an intermediary such as Logstash without the `setup` command being run. When running Elastic Agent in standalone mode this can happen if manually setup data streams have incorrect mappings.
To fix this problem, you typically need to remove your Heartbeat indices and data streams. Then you must create new ones with the appropriate mappings installed. To achieve this, follow the steps below.

### Stop your Heartbeat/Elastic Agent instances

It is necessary to stop all Heartbeat/Elastic Agent instances that are targeting the cluster, so they will not write to or re-create indices prematurely.

### Delete your Heartbeat indices / Elastic Agent data streams

To ensure the mapping is applied to all Heartbeat data going forward, delete all the Heartbeat indices that match the pattern the Uptime app will use.
There are multiple ways to achieve this. You can read about performing this using the [Index Management UI](/docs/manage-data/data-store/index-basics#index-management) or with the [Delete index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-delete).
If using Elastic Agent you will want to fix any issues with custom data stream mappings. We encourage the use of Fleet to eliminate this issue.

### If using Heartbeat, perform Heartbeat setup

The below command will cause Heartbeat to perform its setup processes and recreate the index template properly.
```bash
./heartbeat setup -e
```

For more information on how to use this command, or if you’re using DEB, RPM, or Windows, see the [Heartbeat quickstart guide](https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-installation-configuration).
This command performs the necessary startup tasks and ensures that your indices have the appropriate mapping going forward.

### Run Heartbeat/Elastic Agent again

Now, when you run Heartbeat/Elastic Agent, your data will be indexed with the appropriate mappings. When the Uptime app attempts to fetch your data, it should be able to render without issues.