﻿---
title: Inspect
description: The Inspect view in Kibana allows you to view information about all requests that were made to collect the data displayed on the current page. Many requests...
url: https://www.elastic.co/docs/troubleshoot/observability/inspect
products:
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Inspect
The **Inspect** view in Kibana allows you to view information about all requests that were made to collect the data displayed on the current page.
![Inspector flyout in the Uptime app](https://www.elastic.co/docs/troubleshoot/images/observability-inspect-flyout.png)

Many requests go into building visualizations in Kibana. For example, to render visualizations in the Uptime app, Kibana needs to request a list of all your monitors, data about the availability of each monitor over time, and more. If something goes wrong, the Inspect view can help you report an issue and troubleshoot with Elastic support.
Inspecting requests is available for the following UIs:
- Applications
- Uptime
- User Experience


## Enable inspect

To enable inspect across apps:
1. Go to Kibana's [Advanced Settings](https://www.elastic.co/docs/reference/kibana/advanced-settings).
2. Find the **Observability** section.
3. Turn on the **Inspect ES queries** option.
4. Click **Save changes**.

![Kibana Advanced Settings Observability section with Inspect ES queries enabled](https://www.elastic.co/docs/troubleshoot/images/observability-inspect-enable.png)


## Inspect

Open the inspect flyout by clicking **Inspect** in the top bar.
Click the **Request** dropdown to see all the requests used to make the current page work. Select one to see information about the request below.
![Inspector flyout dropdown for selecting a request to inspect](https://www.elastic.co/docs/troubleshoot/images/observability-inspect-flyout-dropdown.png)

Toggle between the **Statistics**, **Request**, and **Response** tabs to see details for a single request.
The **Statistics** tab provides information about the request including:
<definitions>
  <definition term="Hits">
    The number of documents returned by the query.
  </definition>
  <definition term="Hits (total)">
    The number of documents that match the query.
  </definition>
  <definition term="Data view">
    The data view that connected to the Elasticsearch indices.
  </definition>
  <definition term="Kibana API query parameters">
    The query parameters used in the Kibana API request that initiated the Elasticsearch request.
  </definition>
  <definition term="Kibana API route">
    The route of the Kibana API request that initiated the Elasticsearch request.
  </definition>
  <definition term="Query time">
    The time it took to process the query. Does not include the time to send the request or parse it in the browser.
  </definition>
  <definition term="Request timestamp">
    Time when the start of the request has been logged.
  </definition>
</definitions>

![Inspector flyout Statistics tab](https://www.elastic.co/docs/troubleshoot/images/observability-inspect-flyout-statistics.png)

The **Request** tab shows the exact syntax used in the request. You can click **Copy to clipboard** to copy the request or **Open in Console** to open it in the [Kibana console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console).
![Inspector flyout Request tab with exact syntax](https://www.elastic.co/docs/troubleshoot/images/observability-inspect-flyout-request.png)

The **Response** tab shows the exact response used in the visualizations on the page. You can click **Copy to clipboard** to copy the response.
![Inspector flyout Response tab with exact response](https://www.elastic.co/docs/troubleshoot/images/observability-inspect-flyout-response.png)