﻿---
title: APM Server or Elasticsearch is down
description: If Elasticsearch is down APM Server does not have an internal queue to buffer requests, but instead leverages an HTTP request timeout to act as back-pressure...
url: https://www.elastic.co/docs/troubleshoot/observability/apm/what-happens-when-apm-server-elasticsearch-is-down
products:
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# APM Server or Elasticsearch is down
**If Elasticsearch is down**
APM Server does not have an internal queue to buffer requests, but instead leverages an HTTP request timeout to act as back-pressure. If Elasticsearch goes down, the APM Server will eventually deny incoming requests. Both the APM Server and APM agent(s) will issue logs accordingly.
**If APM Server is down**
Some agents have internal queues or buffers that will temporarily store data if the APM Server goes down. As a general rule of thumb, queues fill up quickly. Assume data will be lost if APM Server goes down. Adjusting these queues/buffers can increase the agent’s overhead, so use caution when updating default values.
- **Go agent** - Circular buffer with configurable size: [`ELASTIC_APM_BUFFER_SIZE`](https://www.elastic.co/docs/reference/apm/agents/go/configuration#config-api-buffer-size).
- **Java agent** - Internal buffer with configurable size: [`max_queue_size`](https://www.elastic.co/docs/reference/apm/agents/java/config-reporter#config-max-queue-size).
- **Node.js agent** - No internal queue. Data is lost.
- **PHP agent** - No internal queue. Data is lost.
- **Python agent** - Internal [Transaction queue](https://www.elastic.co/docs/reference/apm/agents/python/performance-tuning#tuning-queue) with configurable size and time between flushes.
- **Ruby agent** - Internal queue with configurable size: [`api_buffer_size`](https://www.elastic.co/docs/reference/apm/agents/ruby/configuration#config-api-buffer-size).
- **RUM agent** - No internal queue. Data is lost.
- **.NET agent** - No internal queue. Data is lost.