﻿---
title: Processing and performance
description: APM Server performance depends on a number of factors: memory and CPU available, network latency, transaction sizes, workload patterns, agent and server...
url: https://www.elastic.co/docs/troubleshoot/observability/apm/processing-performance
products:
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Processing and performance
APM Server performance depends on a number of factors: memory and CPU available, network latency, transaction sizes, workload patterns, agent and server settings, versions, and protocol.
We tested several scenarios to help you understand how to size the APM Server so that it can keep up with the load that your Elastic APM agents are sending:
- Using the *CPU Optimized* hardware template on AWS, GCP and Azure on Elastic Cloud with the following instances (for more details see [Hardware Profiles](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/ec-change-hardware-profile)):
  - AWS: c6gd
- Azure: fsv2
- GCP: n2.68x32x45
- For each hardware template, testing with several sizes: 1 GB, 4 GB, 8 GB, and 32 GB.
- For each size, using a fixed number of APM agents: 10 agents for 1 GB, 30 agents for 4 GB, 60 agents for 8 GB, and 240 agents for 32 GB.
- In all scenarios, using medium sized events. Events include [transactions](https://www.elastic.co/docs/solutions/observability/apm/transactions) and [spans](https://www.elastic.co/docs/solutions/observability/apm/spans).

<note>
  You will also need to scale up Elasticsearch accordingly, potentially with an increased number of shards configured. For more details on scaling Elasticsearch, refer to the [Elasticsearch documentation](https://www.elastic.co/docs/deploy-manage).
</note>

The results below include numbers for a synthetic workload. You can use the results of our tests to guide your sizing decisions, however, **performance will vary based on factors unique to your use case** like your specific setup, the size of APM event data, and the exact number of agents.

| Profile / Cloud       | AWS                  | Azure               | GCP                  |
|-----------------------|----------------------|---------------------|----------------------|
| **1 GB**(10 agents)   | 19,000events/second  | 17,000events/second | 18,000events/second  |
| **4 GB**(30 agents)   | 33,000events/second  | 23,000events/second | 25,000events/second  |
| **8 GB**(60 agents)   | 52,000events/second  | 36,000events/second | 48,000events/second  |
| **16 GB**(120 agents) | 74,000events/second  | 58,000events/second | 71,000events/second  |
| **32 GB**(240 agents) | 127,000events/second | 90,000events/second | 133,000events/second |

Don’t forget that the APM Server is stateless. Several instances running do not need to know about each other. This means that with a properly sized Elasticsearch instance, APM Server scales out linearly.
<note>
  RUM deserves special consideration. The RUM agent runs in browsers, and there can be many thousands reporting to an APM Server with very variable network latency.
</note>

Alternatively or in addition to scaling the APM Server, consider decreasing the ingestion volume. Read more in [Reduce storage](https://www.elastic.co/docs/solutions/observability/apm/reduce-storage).