﻿---
title: Enable APM Server binary debugging
description: By default, APM Server sends all its output to syslog. When you run APM Server in the foreground, you can use the -e command line flag to redirect the...
url: https://www.elastic.co/docs/troubleshoot/observability/apm/enable-apm-server-binary-debugging
products:
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Enable APM Server binary debugging
<note>
  Fleet-managed users should see [View Elastic Agent logs](https://www.elastic.co/docs/reference/fleet/monitor-elastic-agent) to learn how to view logs and change the logging level of Elastic Agent.
</note>

By default, APM Server sends all its output to syslog. When you run APM Server in the foreground, you can use the `-e` command line flag to redirect the output to standard error instead. For example:
```sh
apm-server -e
```

The default configuration file is apm-server.yml (the location of the file varies by platform). You can use a different configuration file by specifying the `-c` flag. For example:
```sh
apm-server -e -c myapm-serverconfig.yml
```

You can increase the verbosity of debug messages by enabling one or more debug selectors. For example, to view publisher-related messages, start APM Server with the `publisher` selector:
```sh
apm-server -e -d "publisher"
```

If you want all the debugging output (fair warning, it’s quite a lot), you can use `*`, like this:
```sh
apm-server -e -d "*"
```