﻿---
title: APM Server response codes
description: Either you are sending requests to a RUM endpoint without RUM enabled, or a request is coming from an origin not specified in the APM integration settings...
url: https://www.elastic.co/docs/troubleshoot/observability/apm/apm-server-response-codes
products:
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# APM Server response codes
## HTTP 400: Data decoding error / Data validation error

<applies-switch>
  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    The most likely cause for this error is using incompatible versions of APM agent and APM Server. See the [agent/server compatibility matrix](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-compatibility) to verify compatibility.
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    The most likely cause for this error is using an incompatible version of an APM agent. See [minimum supported APM agent versions](/docs/solutions/observability/apm/apm-agents#observability-apm-agents-elastic-apm-agents-minimum-supported-versions) to verify compatibility.
  </applies-item>
</applies-switch>


## HTTP 400: Event too large

<applies-switch>
  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    APM agents communicate with the APM server by sending events in an HTTP request. Each event is sent as its own line in the HTTP request body. If events are too large, you should consider increasing the [Max event size](/docs/solutions/observability/apm/apm-server/general-configuration-options#apm-max_event_size) setting in the APM integration, and adjusting relevant settings in the agent.
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    APM agents communicate with the Managed intake service by sending events in an HTTP request. Each event is sent as its own line in the HTTP request body. If events are too large, you can reduce the size of the events that your APM agents send by: [enabling span compression](https://www.elastic.co/docs/solutions/observability/apm/spans) or [reducing collected stack trace information](/docs/solutions/observability/apm/reduce-storage#observability-apm-reduce-stacktrace).
  </applies-item>
</applies-switch>


## HTTP 401: Invalid token

<applies-switch>
  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    Either the [Secret token](https://www.elastic.co/docs/solutions/observability/apm/secret-token) in the request header doesn’t match the secret token configured in the APM integration, or the [API keys](https://www.elastic.co/docs/solutions/observability/apm/api-keys) is invalid.
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    The API key is invalid.
  </applies-item>
</applies-switch>


## HTTP 403: Forbidden request

Either you are sending requests to a [RUM](https://www.elastic.co/docs/solutions/observability/apm/apm-agents/real-user-monitoring-rum) endpoint without RUM enabled, or a request is coming from an origin not specified in the APM integration settings. See the [Allowed origins](/docs/solutions/observability/apm/apm-server/configure-real-user-monitoring-rum#apm-rum-allow-origins) setting for more information.

## HTTP 503: Request timed out waiting to be processed

This happens when APM Server exceeds the maximum number of requests that it can process concurrently. To alleviate this problem, you can try to: reduce the sample rate and/or reduce the collected stack trace information. See [Reduce storage](https://www.elastic.co/docs/solutions/observability/apm/reduce-storage) for more information.
Another option is to increase processing power. This can be done by either migrating your Elastic Agent to a more powerful machine or adding more APM Server instances.