﻿---
title: Troubleshoot APM
description: This section provides solutions to common questions and problems, and processing and performance guidance. Common problems with APM, What happens when...
url: https://www.elastic.co/docs/troubleshoot/observability/apm
products:
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Troubleshoot APM
This section provides solutions to common questions and problems, and processing and performance guidance.
- [Common problems with APM](https://www.elastic.co/docs/troubleshoot/observability/apm/common-problems)
- [What happens when APM Server or Elasticsearch is down?](https://www.elastic.co/docs/troubleshoot/observability/apm/what-happens-when-apm-server-elasticsearch-is-down)
- [APM Server response codes](https://www.elastic.co/docs/troubleshoot/observability/apm/apm-server-response-codes)
- [Processing and performance](https://www.elastic.co/docs/troubleshoot/observability/apm/processing-performance)
- [APM Server binary debugging](https://www.elastic.co/docs/troubleshoot/observability/apm/enable-apm-server-binary-debugging)
- [APM Server performance diagnostic](https://www.elastic.co/docs/troubleshoot/observability/apm/apm-server-performance-diagnostic)

For additional help with other APM components, see the links below.

## Troubleshooting documentation

Elastic Agent, the Applications UI, and each APM agent has its own troubleshooting guide:
- [Troubleshoot Fleet and Elastic Agent](https://www.elastic.co/docs/troubleshoot/ingest/fleet/fleet-elastic-agent)
- [Troubleshoot APM .NET agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-dotnet/apm-net-agent)
- [Troubleshoot APM Go Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-go/apm-go-agent)
- [Troubleshoot APM Java Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-java/apm-java-agent)
- [Troubleshoot APM Node.js Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-nodejs/apm-nodejs-agent)
- [Troubleshoot APM PHP Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-php/apm-php-agent)
- [Troubleshoot APM Python Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-python/apm-python-agent)
- [Troubleshoot APM Ruby Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-ruby/apm-ruby-agent)
- [Troubleshoot APM Real User Monitoring JavaScript Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-rum-js/apm-real-user-monitoring-javascript-agent)


## Elastic Support

We offer a support experience unlike any other. Our team of professionals *speak human and code* and love making your day. [Learn more about subscriptions](https://www.elastic.co/subscriptions).

## Discussion forum

For additional questions and feature requests, visit our [discussion forum](https://discuss.elastic.co/c/apm).