﻿---
title: Amazon Data Firehose
description: You can use the monitoring tab in the Firehose console to ensure there are incoming records and the delivery success rate is 100%. By default Firehose...
url: https://www.elastic.co/docs/troubleshoot/observability/amazon-data-firehose
products:
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Amazon Data Firehose
You can use the monitoring tab in the Firehose console to ensure there are incoming records and the delivery success rate is 100%. By default Firehose also logs to a Cloudwatch log group with the name `/aws/kinesisfirehose/<delivery stream name>`, which is automatically created when the delivery stream is created. Two log streams, `DestinationDelivery` and `BackupDelivery`, are created in this log group.
The backup settings in the delivery stream specify how failed delivery requests are handled. For more details on how to configure backups to S3, refer to [Step 3: Specify the destination settings for your Firehose stream](/docs/solutions/observability/cloud/monitor-amazon-web-services-aws-with-amazon-data-firehose#firehose-step-three).

## Scaling

Firehose can [automatically scale](https://docs.aws.amazon.com/firehose/latest/dev/limits.html) to handle very high throughput. If your Elastic deployment is not properly configured for the data volume coming from Firehose, it could cause a bottleneck, which may lead to increased ingest times or indexing failures.
There are several facets to optimizing the underlying Elasticsearch performance, but Elastic Cloud provides several ready-to-use hardware profiles which can provide a good starting point. Other factors which can impact performance are [shard sizing](https://www.elastic.co/docs/deploy-manage/production-guidance/optimize-performance/size-shards), [indexing configuration](https://www.elastic.co/docs/deploy-manage/production-guidance/optimize-performance/indexing-speed), and [index lifecycle management (ILM)](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management).

## Support

If you encounter further problems, [contact us](/docs/troubleshoot#contact-us).