﻿---
title: Understanding node moves and system maintenance
description: To ensure that your deployment nodes are located on healthy hosts, Elastic vacates nodes to perform essential system maintenance or to remove a host with...
url: https://www.elastic.co/docs/troubleshoot/monitoring/node-moves-outages
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Understanding node moves and system maintenance
To ensure that your deployment nodes are located on healthy hosts, Elastic vacates nodes to perform essential system maintenance or to remove a host with hardware issues from service. These tasks cannot be skipped or delayed.
You can subscribe to the [status page](https://status.elastic.co/) to be notified about planned maintenance or actions that have been taken to respond to incidents.
If events on your deployment don’t correlate to any items listed on the status page, the events are due to minor essential maintenance performed on only a subset of Elastic Cloud Hosted deployments.
When Elastic Cloud Hosted undergoes system maintenance, the following message appears on the [activity page](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/keep-track-of-deployment-activity):
```sh
Move nodes off of allocator [allocator_id] due to essential system maintenance.
```

This page explains the causes and impact of node moves and system maintenance, and how to mitigate any possible risks to your deployment.
<note>
  You can also [configure email notifications](#configure-email-notification) to be alerted when this situation occurs.
</note>


## Possible causes

Potential causes of system maintenance include, but not limited to, situations like the following:
- A host where the Cloud Service Provider (CSP), like AWS, GCP, or Azure, has reported upcoming hardware deprecation or identified issues requiring remediation.
- Abrupt host termination by the CSP due to underlying infrastructure problems.
- Mandatory host operating system (OS) patching or upgrades for security or compliance reasons.
- Other scheduled maintenance announced on the [Elastic status page](https://status.elastic.co/).


## Behavior difference

Depending on the cause, the maintenance behaviors may differ.
- During planned operations, such as hardware upgrades or host patches, the system attempts to gracefully move the node to another host before shutting down the original one. This process allows shard relocation to complete ahead of time, minimizing any potential disruption.
- If a node’s host experiences an unexpected outage, the system automatically vacates the node and displays a related `Don't attempt to gracefully move shards` message on the [activity page](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/keep-track-of-deployment-activity), skipping the check to ensure the node’s shards have been moved before shutdown.


## Impact and mitigation

The following sections describe how your deployment behaves during maintenance, and how to reduce risks of data loss.

### Service availability

The system will automatically try to recover the vacated node’s data from replicas or snapshots. If your cluster has [high availability (HA)](/docs/deploy-manage/deploy/elastic-cloud/elastic-cloud-hosted-planning#ec-ha) configured, all search and indexing requests should continue to work within the reduced capacity until the node is replaced.
Overall, having replicas and multiple availability zones helps minimize service interruption.

### Data resiliency

The system maintenance process always attempts to recover the vacated node's data from replicas or snapshots. However, if the deployment is not configured with high availability, the maintenance process might not be able to recover the data from the vacated node.
Configuring multiple availability zones helps your deployment remain available for indexing and search requests if one zone becomes unavailable. However, this alone does not guarantee data availability. If an index has no replica shards and its primary shard is located on a node that must be vacated, data loss might occur if the system is unable to move the node gracefully during the maintenance activity.
To minimize this risk and keep your data accessible, ensure that your deployment follows [high availability best practices](/docs/deploy-manage/deploy/elastic-cloud/elastic-cloud-hosted-planning#ec-ha):
- Use at least two availability zones for production systems, and three for mission-critical systems.
- Configure one or more [replica shards](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards) for each index, except for searchable snapshot indices.

As long as these recommendations are followed, system maintenance processes should not impact the availability of the data in the deployment.

### Performance stability

The performance impact of system maintenance depends on how well the deployment is sized. Well-provisioned deployments with sufficient buffer capacity typically remain unaffected, while deployments already operating near their limits might experience slowdowns, or even intermittent request failures, during node vacating.
High availability assumes not just redundancy in data and zones, but also the ability to absorb the loss or restart of a node without service disruption. To learn more, refer to [Plan for production](/docs/deploy-manage/deploy/elastic-cloud/elastic-cloud-hosted-planning#ec-ha).
At a minimum, you should size your deployment to tolerate the temporary loss of one node in order to avoid single points of failure and ensure proper HA. For critical systems, ensure that the deployment can continue operating even in the event of losing an entire availability zone.
<admonition title="Availability zones and sizing recommendations">
  Increasing the number of zones should not be used to add more resources. The concept of zones is meant for high availability (two zones) and fault tolerance (three zones), but neither will work if the cluster relies on the resources from those zones to be operational.You should scale up the resources within a single zone until the cluster can take the full load, adding some buffer to be prepared for a peak of requests. You should then scale out by adding additional zones depending on your requirements: two zones for high availability, three zones for fault tolerance.
</admonition>


## Configure email notifications

You can configure email alerts for system maintenance by following these steps:
1. Enable [Stack monitoring](/docs/deploy-manage/monitor/stack-monitoring/ece-ech-stack-monitoring#enable-logging-and-monitoring-steps) (logs and metrics) on your deployment. Only metrics collection is required for these notifications to work.
2. In the deployment used as the destination of Stack monitoring:

- Create [Stack monitoring default rules](/docs/deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts#_create_default_rules).
- (Optional) Configure an email [connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type). If you prefer, use the preconfigured `Elastic-Cloud-SMTP` email connector.
- Edit the rule  **Cluster alerting** > **Elasticsearch nodes changed** and select the email connector.

<note>
  If you have only one master node in your cluster, no notification will be sent during the master node vacate. Kibana needs to communicate with the master node in order to send a notification. You can avoid this by shipping your deployment metrics to a dedicated monitoring cluster when you enable logging and monitoring.
</note>