﻿---
title: Troubleshoot deployment health warnings on Elastic Cloud Hosted
description: The Elastic Cloud Deployments page shows the current status of your active deployments. From time to time you may get one or more health warnings, such...
url: https://www.elastic.co/docs/troubleshoot/monitoring/deployment-health-warnings
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Troubleshoot deployment health warnings on Elastic Cloud Hosted
The Elastic Cloud [Deployments](https://cloud.elastic.co/deployments) page shows the current status of your active deployments. From time to time you may get one or more health warnings, such as the following:
![A screen capture of the deployment page showing a typical warning: Deployment health warning: Latest change to Elasticsearch configuration failed.](https://www.elastic.co/docs/troubleshoot/images/cloud-ec-ce-deployment-health-warning.png)

**Single warning**
To resolve a single health warning, we recommended first re-applying any pending changes: Select **Edit** in the deployment menu to open the Edit page and then click **Save** without making any changes. This will check all components for pending changes and will apply the changes as needed. This may impact the uptime of clusters which are not [highly available](https://www.elastic.co/docs/deploy-manage/production-guidance/availability-and-resilience/resilience-in-ech).
Re-saving the deployment configuration without making any changes is often all that’s needed to resolve a transient health warning on the UI. Saving will redirect you to the Elastic Cloud Hosted deployment [Activity page](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/keep-track-of-deployment-activity) where you can monitor plan completion. Repeat errors should be investigated; for more information refer to [resolving configuration change errors](https://www.elastic.co/docs/troubleshoot/monitoring/node-bootlooping).
**Multiple warnings**
If multiple health warnings appear for one of your deployments, or if your deployment is unhealthy, we recommend [Getting help](https://www.elastic.co/docs/troubleshoot) through the Elastic Support Portal.
**Warning about system changes**
If the warning refers to a system change, check the deployment’s [Activity](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/keep-track-of-deployment-activity) page.
<admonition title="Simplify monitoring with AutoOps">
  AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths. Learn more about [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops).
</admonition>


## Additional resources

- [Troubleshoot deployment health warnings on Elastic Cloud Enterprise](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/deployment-health-warnings)
- [Troubleshooting overview](https://www.elastic.co/docs/troubleshoot)