﻿---
title: Troubleshoot Kibana reporting
description: Kibana excels as a data visualization tool. The reporting features exist to export data as simple reports, however Kibana is not a data export tool. To...
url: https://www.elastic.co/docs/troubleshoot/kibana/reporting
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Troubleshoot Kibana reporting
Kibana excels as a data visualization tool. The reporting features exist to export data as simple reports, however Kibana is not a data export tool. To export data at a large scale, there are better ways and better architectures for exporting data at scale from Elasticsearch.
If you have trouble creating simple reports, there are some general solutions to common problems you might encounter while using reporting features. For tips related to specific types of reports, refer to [CSV](https://www.elastic.co/docs/explore-analyze/report-and-share/reporting-troubleshooting-csv) and [PDF/PNG](https://www.elastic.co/docs/explore-analyze/report-and-share/reporting-troubleshooting-pdf).

## Error messages

There are some common solutions for error messages that you might encounter in reporting features.

### Version conflict engine exceptions

If you are running multiple instances of Kibana in a cluster, the instances share the work of running report jobs to evenly distribute the workload. Each instance searches the reporting index for "pending" jobs that the user has requested. It is possible for multiple instances to find the same job in these searches. Only the instance that successfully updated the job status to "processing" will actually run the report job. The other instances that unsuccessfully tried to make the same update will log something similar to this:
```text
StatusCodeError: [version_conflict_engine_exception] [...]: version conflict, required seqNo [6124], primary term [1]. current document has seqNo [6125] and primary term [1], with { ... }
  status: 409,
  displayName: 'Conflict',
  path: '/.reporting-...',
  body: {
    error: {
      type: 'version_conflict_engine_exception',
      reason: '[...]: version conflict, required seqNo [6124], primary term [1]. current document has seqNo [6125] and primary term [1]',
    },
  },
  statusCode: 409
}
```

These messages alone don’t indicate a problem. They show normal events that happen in a healthy system.

### Max attempts reached

There are two primary causes for a "Max attempts reached" error:
- You’re creating a PDF of a visualization or dashboard that spans a large amount of data and Kibana is hitting the `xpack.reporting.queue.timeout`
- Kibana is hosted behind a reverse-proxy, and the [Kibana server settings](https://www.elastic.co/docs/reference/kibana/configuration-reference/reporting-settings#reporting-kibana-server-settings) are not configured correctly

Create a Markdown visualization and then create a PDF report. If this succeeds, increase the `xpack.reporting.queue.timeout` setting. If the PDF report fails with "Max attempts reached," check your [Kibana server settings](https://www.elastic.co/docs/reference/kibana/configuration-reference/reporting-settings#reporting-kibana-server-settings).

## Verbose logging

Kibana server logs have a lot of useful information for troubleshooting and understanding how things work. The full logs from reporting features are a good place to look when you encounter problems. In [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings):
```yaml
logging.root.level: all
```

For more information about logging, check out [Kibana configuration settings](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#logging-root-level).