﻿---
title: Error: Kibana server is not ready yet
description: To troubleshoot the Kibana server is not ready yet error, try these steps: From within a Kibana node, confirm the connection to Elasticsearch:, Guarantee...
url: https://www.elastic.co/docs/troubleshoot/kibana/error-server-not-ready
products:
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Error: Kibana server is not ready yet
To troubleshoot the `Kibana server is not ready yet` error, try these steps:
1. From within a Kibana node, confirm the connection to Elasticsearch:
   ```sh
   curl -XGET elasticsearch_ip_or_hostname:9200/
   ```
2. Guarantee the health of the three Kibana-backing indices.  All indices must appear and display `status:green` and `status:open`:
   ```sh
   curl -XGET elasticsearch_ip_or_hostname:9200/_cat/indices/.kibana,.kibana_task_manager,.kibana_security_session,.security*?v=true
   ```
   These Kibana-backing indices must also not have [index settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-settings) flagging `read_only_allow_delete` or `write` [index blocks](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-block).
3. [Shut down all Kibana nodes](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-kibana).
4. Choose any Kibana node, then update the config to set the [debug logging](/docs/deploy-manage/monitor/logging-configuration/kibana-log-settings-examples#change-overall-log-level).
5. [Start the node](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-kibana), then check the start-up debug logs for `ERROR` messages or other start-up issues.
   For example:
   - When Kibana is unable to connect to a healthy Elasticsearch cluster, errors like `master_not_discovered_exception` or `unable to revive connection` or `license is not available` errors appear.
- When one or more Kibana-backing indices are unhealthy, the `index_not_green_timeout` error appears.


## Resources

- [Kibana health troubleshooting walkthrough](https://www.elastic.co/blog/troubleshooting-kibana-health)
- [Kibana health troubleshooting video](https://www.youtube.com/watch?v=AlgGYcpGvOA)