﻿---
title: No logs, metrics, or traces visible in Kibana
description: Learn what to check when no data (logs, metrics, traces) appears in Kibana after setting up EDOT.
url: https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/no-data-in-kibana
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# No logs, metrics, or traces visible in Kibana
If the EDOT Collector or SDKs appear to be running, but you see no logs, metrics, or traces in the Kibana UI, try to use these solutions to identify and resolve the issue.
<tip>
  If you're sending EDOT SDK telemetry directly to APM Server's OTel intake, keep in mind that this flow is not supported. Send data to an [EDOT Collector Gateway](https://www.elastic.co/docs/reference/edot-collector/modes#edot-collector-as-gateway) or [Managed OTel intake](https://www.elastic.co/docs/reference/opentelemetry/motlp) instead.
</tip>


## Symptoms

- Collector process is consuming CPU/memory but no telemetry data is visible in Kibana
- APM services don’t show up in Kibana
- Dashboards appear empty or partially loaded
- The Collector is running without crash logs


## Causes

This issue is typically caused by one or more of the following:
- Incorrect export endpoint
- Missing or invalid API key/token
- Network issues, such as proxy misconfigurations
- TLS verification failures
- Misconfigured pipelines or disabled signals
- Incomplete setup — to capture all telemetry data, you must use the EDOT Collector together with an appropriate EDOT SDK


## Resolution

Use the following checks to identify and fix common configuration or connectivity issues that can prevent telemetry data from reaching Kibana.

### Check export endpoint

Make sure the Collector is configured to send data to the correct Elastic endpoint.
To confirm:
1. Open Kibana for your deployment.
2. In the top right, select **Add data**.
3. Select **Application** > **OpenTelemetry**.
4. In the **APM Agents** panel, locate **OpenTelemetry**.
5. Ensure the `endpoint` in your Collector configuration matches exactly.

If you’re using the managed OTLP endpoint, confirm the region and cluster ID are correct.

### Verify authentication headers

Ensure the Collector or SDK includes an API key in the `Authorization` header:
```yaml
headers:
  Authorization: ApiKey <your-api-key>
```

If you’re using environment variables, confirm the key is set correctly in the runtime context.

### Review logs for export errors

Common log messages include:
```
permanent error: rpc error: code = Unavailable desc = connection refused
```

Also look for:
- TLS handshake failures
- Invalid character errors, which may indicate proxy or HTML redirect instead of JSON

Increase verbosity using `--log-level=debug` for deeper insights. For more information, refer to [Enable debug logging for the EDOT Collector](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector/enable-debug-logging) or [Enable debug logging for EDOT SDKs](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/enable-debug-logging).

### Test network connectivity

You can validate connectivity using `curl`:
```bash
curl -v https://<endpoint> -H "Authorization: ApiKey <your-key>"
```

Or use `telnet` or `nc` to verify port 443 is reachable. For detailed connectivity troubleshooting, refer to [Connectivity issues](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/connectivity).

### Validate signal configuration

Check that each pipeline is defined properly in your configuration:
```yaml
service:
  pipelines:
    traces:
      receivers: [otlp]
      processors: [...]
      exporters: [otlp]
```

If only logs are configured, metrics and traces will not be sent.
If you're using EDOT SDKs and not seeing application-level telemetry, refer to [No application-level telemetry visible in Kibana](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/missing-app-telemetry) for SDK-specific troubleshooting.