﻿---
title: Proxy issues with EDOT Java SDK
description: Troubleshooting guide for the EDOT Java SDK, covering proxy issues.
url: https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/java/proxy-issues
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Java
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Java: Generally available
---

# Proxy issues with EDOT Java SDK
If your Java SDK sends telemetry but fails to communicate with the APM server, the issue might be due to missing or misconfigured proxy settings, which are required for outbound HTTP/S communication in some environments. For general proxy configuration guidance, refer to [Proxy settings for EDOT SDKs](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/proxy). For connectivity troubleshooting, refer to [Connectivity issues](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/connectivity).

## Symptoms

These symptoms typically indicate that your Java SDK is experiencing a proxy issue:
- Telemetry data is not received in Elastic APM after instrumenting the app.
- Logs show errors like `Connection timed out`, `TLS handshake failure`, or other network-related issues when connecting to Elastic APM.


## Resolution

Set standard Java system properties to configure proxy settings.
Configure the following JVM system properties to enable outbound HTTP/HTTPS communication through a proxy:
```bash
java \
-Dhttp.proxyHost=proxy.example.com \
-Dhttp.proxyPort=8080 \
-Dhttps.proxyHost=proxy.example.com \
-Dhttps.proxyPort=8080 \
```


## Best practices

You can test end-to-end connectivity to validate proxy routing. To confirm that your application or collector can reach the endpoint through the proxy, use `curl` with the `--proxy` option:
```bash
curl --proxy http://proxy.example.com:8080 https://example.elastic.co
```

If the proxy is working, you'll get a valid response. If not, common errors include:
- `Connection timed out`
- `Could not resolve host`
- `Proxy CONNECT aborted`


## Resources

- [Java networking and proxies](https://docs.oracle.com/javase/8/docs/technotes/guides/net/proxies.html)
- [Java agent configuration - upstream documentation](https://opentelemetry.io/docs/zero-code/java/agent/configuration/)