﻿---
title: Troubleshooting the EDOT SDKs
description: Troubleshoot issues with the EDOT SDKs using these guides.
url: https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Troubleshooting the EDOT SDKs
Find solutions to common issues with EDOT SDKs for various programming languages and platforms.
- [Android SDK](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/android): Troubleshoot common problems affecting the Elastic Distribution of OpenTelemetry Android SDK.
- [.NET SDK](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/dotnet): Troubleshoot common problems affecting the EDOT .NET SDK.
- [iOS SDK](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/ios): Troubleshoot common problems affecting the Elastic Distribution of OpenTelemetry iOS agent.
- [Java SDK](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/java): Troubleshoot common problems affecting the EDOT Java agent, including connectivity, agent identification, and debugging.
- [Node.js SDK](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/nodejs): Troubleshoot issues using EDOT Node.js SDK.
- [PHP SDK](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/php): Troubleshoot issues using EDOT PHP agent.
- [Python SDK](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/python): Troubleshoot issues using EDOT Python agent.


## Shared troubleshooting topics

These guides apply to all EDOT SDKs:
- [Enable debug logging](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/enable-debug-logging): Learn how to enable debug logging for EDOT SDKs to troubleshoot application-level instrumentation issues.
- [No application-level telemetry visible in Kibana](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/missing-app-telemetry): Diagnose lack of telemetry flow due to issues with EDOT SDKs.
- [Proxy settings for EDOT SDKs](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/proxy): Configure proxy settings for EDOT SDKs when your application runs behind a proxy.
- [Missing or incomplete traces due to SDK sampling](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/misconfigured-sampling-sdk): Troubleshoot missing or incomplete traces caused by SDK-level sampling configuration.


## Supported architectures

EDOT SDKs are tested and supported only with [EDOT Collector Gateway](https://www.elastic.co/docs/reference/edot-collector/modes#edot-collector-as-gateway) or [Managed OTel intake](https://www.elastic.co/docs/reference/opentelemetry/motlp). Using EDOT SDKs directly with APM Server's OTel intake is not supported.

## See also

- [EDOT Collector troubleshooting](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector): For end-to-end issues that may involve both the Collector and SDKs.
- [Troubleshoot EDOT](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry): Overview of all EDOT troubleshooting resources.

<warning>
  Avoid using EDOT SDKs alongside any other APM agent, including Elastic APM agents. Running multiple agents in the same application process may lead to unexpected behavior, conflicting instrumentation, or duplicated telemetry.
</warning>