﻿---
title: Troubleshoot the EDOT Collector
description: Troubleshooting common issues with the EDOT Collector.
url: https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Troubleshoot the EDOT Collector
Use the topics in this section to troubleshoot issues with the EDOT Collector.
If you're not sure where to start, review the Collector's logs for error messages and validate your configuration using the `--dry-run` option. For more detailed diagnostics, refer to [Enable debug logging](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector/enable-debug-logging).

## Resource issues

- [Collector out of memory](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector/collector-oomkilled): Diagnose and resolve out-of-memory issues in the EDOT Collector using Go's Performance Profiler.
- [Insufficient resources in Kubernetes](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector/insufficient-resources-kubestack): Troubleshoot resource allocation issues when running the EDOT Collector in Kubernetes environments.


## Configuration issues

- [Collector doesn't start](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector/collector-not-starting): Resolve startup failures caused by invalid configuration, port conflicts, or missing components.
- [Missing or incomplete traces due to Collector sampling](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector/misconfigured-sampling-collector): Troubleshoot missing or incomplete traces caused by sampling configuration.
- [Collector doesn't propagate client metadata](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector/metadata): Learn why the Collector doesn't extract custom attributes and how to propagate such values using EDOT SDKs.


## Connectivity and export issues

- [Export failures when sending telemetry data](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector/trace-export-errors): Resolve export failures caused by `sending_queue` overflow and Elasticsearch exporter timeouts.
- [`ResourceExhausted` errors and decompression limits in Collector-to-Collector pipelines](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector/c2c-resourceexhausted): Troubleshoot `ResourceExhausted` errors caused by gRPC message size limits, decompression limits, memory pressure, or backpressure in Collector-to-Collector pipelines.


## Debugging

- [Enable debug logging](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector/enable-debug-logging): Learn how to enable debug logging for the EDOT Collector in supported environments.


## See also

- [EDOT SDKs troubleshooting](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks): For end-to-end issues that may involve both the Collector and SDKs.
- [Troubleshoot EDOT](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry): Overview of all EDOT troubleshooting resources.

For in-depth details on troubleshooting, refer to the contrib [OpenTelemetry Collector troubleshooting documentation](https://opentelemetry.io/docs/collector/troubleshooting/).