﻿---
title: Troubleshoot Elastic Distributions of OpenTelemetry (EDOT)
description: Troubleshoot EDOT issues using these guides.
url: https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Troubleshoot Elastic Distributions of OpenTelemetry (EDOT)
Find solutions to common issues in EDOT components and SDKs.

## Component troubleshooting

- [EDOT Collector troubleshooting](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector): Troubleshoot issues with the EDOT Collector, including resource problems, configuration errors, and connectivity issues.
- [EDOT SDKs troubleshooting](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks): Troubleshoot issues with EDOT SDKs for Android, .NET, iOS, Java, Node.js, PHP, and Python.


## Common troubleshooting topics

These guides apply to both the Collector and SDKs:
- [Connectivity issues](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/connectivity): Resolve connection problems between EDOT components and Elastic, including firewall, proxy, and network configuration issues.
- [No data visible in Kibana](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/no-data-in-kibana): Diagnose why telemetry data (logs, metrics, traces) doesn't appear in Kibana after setting up EDOT.
- [429 errors when using the mOTLP endpoint](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/429-errors-motlp): Resolve HTTP 429 `Too Many Requests` errors when sending data through the Elastic Cloud Managed OTLP endpoint.
- [Contact support](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/contact-support): Learn how to contact Elastic Support and what information to include to help resolve issues faster.


## Supported architectures

EDOT SDKs are tested and supported only with [EDOT Collector Gateway](https://www.elastic.co/docs/reference/edot-collector/modes#edot-collector-as-gateway) or [Managed OTel intake](https://www.elastic.co/docs/reference/opentelemetry/motlp). Using EDOT SDKs directly with APM Server's OTel intake is not supported.

## Additional resources

- [Troubleshoot ingestion tools](https://www.elastic.co/docs/troubleshoot/ingest): Overview of troubleshooting for all ingestion tools, including EDOT, Logstash, Fleet, and Beats.
- [Elastic Support Portal](https://support.elastic.co/): Access support cases, subscriptions, and licenses.
- [Elastic community forums](https://discuss.elastic.co): Get answers from experts in the community, including Elastic team members.