﻿---
title: Frequently asked questions
description: We have collected the most frequently asked questions here. If your question isn’t answered here, contact us in the discuss forum. Your feedback is very...
url: https://www.elastic.co/docs/troubleshoot/ingest/fleet/frequently-asked-questions
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Frequently asked questions
We have collected the most frequently asked questions here. If your question isn’t answered here, contact us in the [discuss forum](https://discuss.elastic.co/). Your feedback is very valuable to us.
Also read [Troubleshoot common problems](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems).
- [Why doesn’t my enrolled agent show up in the Fleet app?](#enrolled-agent-not-showing-up)
- [Where does Elastic Agent store logs after startup?](#where-are-the-agent-logs)
- [What policy is the Elastic Agent running?](#what-is-my-agent-config)
- [Why can’t I see the data Elastic Agent is sending?](#where-is-the-data-agent-is-sending)
- [How do I restore an Elastic Agent that I deleted from Fleet?](#i-deleted-my-agent)
- [How do I restart Elastic Agent after rebooting my host?](#i-rebooted-my-host)
- [Does Elastic Agent or Kibana download integration packages?](#does-agent-download-packages)
- [Does Elastic Agent download anything from the Internet?](#does-agent-download-anything-from-internet)
- [Do I need to set up the Beats managed by Elastic Agent?](#do-i-need-to-setup-elastic-agent)
- [What is the Elastic Defend integration in Fleet?](#what-is-the-endpoint-package)
- [How are communications secured between Elastic Security and Elastic Agent?](#how-are-security-to-agent-communications-secured)
- [How are secrets secured when entered into integration policies or agent policies in Kibana?](#how-are-secrets-secured)
- [Which Elasticsearch and Kibana ports need to be accessible?](#which-es-kibana-ports-are-needed)
- [If I delete an integration dashboard asset from Kibana, how do I get it back?](#how-do-i-reinstall-a-missing-dashboard-asset)


## Why doesn’t my enrolled agent show up in the Fleet app?

If Elastic Agent was successfully enrolled, but doesn’t show up in the **Agents** list, it might not be started. Make sure the `elastic-agent` process is running on the host. If it’s not running, use the [`run`](/docs/reference/fleet/agent-command-reference#elastic-agent-run-command) command to start it.  The most common way to deploy an Elastic Agent is by using the `install` command. This command starts the Elastic Agent for you.

## Where does Elastic Agent store logs after startup?

The location of Elastic Agent logs varies by platform. In general, Elastic Agent stores logs under the `data` directory where Elastic Agent was started. For example, on macOS, you’ll find logs for the running Elastic Agent under path similar to:
`/Library/Elastic/Agent/data/elastic-agent-08e204/logs/elastic-agent-20220105.ndjson`
You’ll find logs for the Beats shippers, such as Metricbeat, under paths like:
`/Library/Elastic/Agent/data/elastic-agent-08e204/logs/default/metricbeat-20220105.ndjson`
If the log path does not exist, Elastic Agent was unable to start Metricbeat, which is a higher level problem to triage. Usually you can see these logs in the Fleet UI, unless there are problems severe enough that the Elastic Agent or its related  processes cannot send data to Elasticsearch.
See [Installation layout](https://www.elastic.co/docs/reference/fleet/installation-layout) to find out the exact paths for each platform.

## What policy is the Elastic Agent running?

To find the policy file, inspect the `elastic-agent.yml` file in the directory where Elastic Agent is running. Not sure where the agent is running? See [Installation layout](https://www.elastic.co/docs/reference/fleet/installation-layout).
If the agent is running in Fleet mode, this file contains the following citation:
```yaml
fleet:
  enabled: true
```

The `state.yml` file (located under `data/elastic-agent-*`) contains the entire, unencrypted policy.
- To see the Elasticsearch location, look at the `hosts` setting under `outputs`. For example:
  ```json
  outputs:
    default:
      api_key: Aq-mPpcBDA7TmnriKCSD:Np6NAleNQ1mMpgN_JPYazw
      hosts:
      - https://3m63533c175a4036b3d8bbe7bd462fa3.us-east-1.aws.found.io:443
      type: elasticsearch
  ```
  This file also shows the version of all packages used by the current policy.
- To see the Elastic Agent version, run:
  ```shell
  elastic-agent version
  ```


## Why can’t I see the data Elastic Agent is sending?

If Elastic Agent is set up and running, but you don’t see data in Kibana:
1. Go to **Management > Dev Tools** in Kibana, and in the Console, search your index for data. For example:
   ```json
   ```
   Or if you prefer, go to the **Discover** app.
2. Look at the data that Elastic Agent has sent and see if the `name.host` field contains your host machine name.

If you don’t see data for your host, it’s possible that the data is blocked in the network, or that a firewall or security problem is preventing the Elastic Agent from sending the data.
Although it’s redundant to install stand-alone Metricbeat, you might want to try installing it to see if it’s able to send data successfully to Elasticsearch. For more information, see [Metricbeat quick start](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration).
If Metricbeat is able to send data to Elasticsearch, there is possibly a bug or problem with Elastic Agent, and you should report it.

## How do I restore an Elastic Agent that I deleted from Fleet?

It’s okay, we’ve got your back! The data is still in Elasticsearch. To add Elastic Agent to Fleet again, [Stop Elastic Agent](/docs/reference/fleet/start-stop-elastic-agent#stop-elastic-agent-service), re-enroll it on the host, then run Elastic Agent.

## How do I restart Elastic Agent after rebooting my host?

Elastic Agent should restart automatically when you reboot your host. If it doesn’t, you can start it manually by running:
```shell
elastic-agent run
```

If the process is already running, you can restart it by running:
```shell
elastic-agent restart
```


## Does Elastic Agent or Kibana download integration packages?

Elastic Agent does not download integration packages. When you add an integration in Fleet, Kibana connects to the Elastic Package Registry at `epr.elastic.co`, downloads the integration package, and stores its assets in Elasticsearch. This means that you no longer have to run a manual setup command to load integrations as you did previously with Beats modules.
By default, Kibana requires an internet connection to download integration packages from the Elastic Package Registry. If network restrictions prevent Kibana from reaching the public Elastic Package Registry, you can use a proxy server or host your own Elastic Package Registry. To learn more, refer to [Air-gapped environments](https://www.elastic.co/docs/reference/fleet/air-gapped).

## Does Elastic Agent download anything from the Internet?

- In version 7.10 and later, a fully capable artifact can be installed with no connection to the Elastic download site. However, if it is in use, the Elastic Defend process is instructed to attempt to download newer released versions of the integration-specific artifacts it uses. Some of those are, for example, the malware model, trusted applications artifact, exceptions list artifact, and others. Elastic Endpoint will continue to protect the host even if it’s unable to download updates. However, it won’t receive updates to protections until Elastic Agent is upgraded to a new version. For more information, refer to the [Elastic Security documentation](https://www.elastic.co/docs/solutions/security).
- Elastic Agent requires internet access to download artifacts for binary upgrades. In air-gapped environments, you can host your own artifact registry. For more information, refer to [Air-gapped environments](https://www.elastic.co/docs/reference/fleet/air-gapped).


## Do I need to set up the Beats managed by Elastic Agent?

You might have noticed that Elastic Agent runs Beats under the hood. But note that the Beats managed by Elastic Agent are set up and run differently from standalone Beats.
For example, standalone Beats use modules and require you to run a setup command on the host to load assets, such as ingest pipelines and dashboards. In contrast, Beats managed by Elastic Agent use integration packages that Kibana downloads from the Elastic Package Registry at `epr.elastic.co`. This means that Elastic Agent does not need extra privileges to set up assets because Fleet manages the assets.

## What is the Elastic Defend integration in Fleet?

The Elastic Defend integration provides protection on your Elastic Agent controlled host. The integration monitors your host for security-related events, allowing for investigation of security data through the Elastic Security app in Kibana. The Elastic Defend integration is managed by Elastic Agent in the same way as other integrations. Try it out! For more information, refer to the [Elastic Security documentation](https://www.elastic.co/docs/solutions/security).

## How are communications secured between Elastic Security and Elastic Agent?

Elastic Security connects to the agent over loopback TLS on port 6788. Elastic Security validates that the agent has root (Linux and macOS) or SYSTEM (Windows) permissions.

## How are secrets secured when entered into integration policies or agent policies in Kibana?

Credentials that you provide for an agent or integration policy are stored in Elasticsearch. They can be read by any user who has read permissions to the `.fleet-*` and `.kibana*` indices in Elasticsearch. By default these are the superuser, `fleet-server` service account tokens, and the `kibana_system` user. These secrets are also included in agent policies and shared with agents via Fleet through TLS. When you use the Elastic Agent installer and enroll agents in Fleet, the policies are stored on the host file system and, by default, can only be read by root.

## Which Elasticsearch and Kibana ports need to be accessible?

The policy generated by Fleet already contains the correct Elasticsearch address and port for your setup. If you run everything locally, the address is `127.0.0.1:9200`. If you use [Elastic Cloud Hosted](https://www.elastic.co/cloud/elasticsearch-service?page=docs&placement=docs-body), you can copy the Elasticsearch endpoint URL from the overview page of your deployment. If you’re not running in Elastic Cloud, make sure the Kibana and Elasticsearch HTTPS ports are both accessible; by default these are `5601` and `9200` respectively.

## If I delete an integration dashboard asset from Kibana, how do I get it back?

To reinstall the assets for a specific integration, you can use the Fleet UI. For more information, see [Reinstall integration assets](/docs/reference/fleet/install-uninstall-integration-assets#reinstall-integration-assets).
Alternatively, you can use the Fleet API using the package name and version. This needs to be run against the Kibana API and not the Elasticsearch API to be successful. To reinstall package assets, execute the following call with the `force` parameter in the body:
```bash
POST api/fleet/epm/packages/[package name]/[package version]
{ "force": true }
```

So, for example, to reinstall the system v1.0.0 package, POST:
```bash
POST api/fleet/epm/packages/system/1.0.0
{ "force": true }
```

The package version is shown in the Integrations view in Kibana.