﻿---
title: Elastic Logging Plugin for Docker
description: You can set the debug level to capture debugging output about the Elastic Logging Plugin. To set the debug level: Disable the plugin:, Set the debug level:,...
url: https://www.elastic.co/docs/troubleshoot/ingest/beats-loggingplugin/elastic-logging-plugin-for-docker
products:
  - Beats
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Logging Plugin for Docker
You can set the debug level to capture debugging output about the Elastic Logging Plugin. To set the debug level:
1. Disable the plugin:
   ```sh
   docker plugin disable elastic/elastic-logging-plugin:9.3.0
   ```
2. Set the debug level:
   ```sh
   docker plugin set elastic/elastic-logging-plugin:9.3.0 LOG_DRIVER_LEVEL=debug
   ```
   Where valid settings for `LOG_DRIVER_LEVEL` are `debug`, `info`, `warning`, or `error`.
3. Enable the plugin:
   ```sh
   docker plugin enable elastic/elastic-logging-plugin:9.3.0
   ```

To view the logs:
On Linux, the Elastic Logging Plugin logs are written to the same location as other docker logs, typically the system journal.
On MacOS, locating the logs is more complicated. For more information, see the [Debugging on MacOS](https://github.com/elastic/beats/tree/master/x-pack/dockerlogbeat#debugging-on-macos) section in the readme file.