﻿---
title: Troubleshoot Watcher
description: If you get the Dynamic Mapping is Disabled error when you try to add a watch, verify that the index mappings for the .watches index are available. You...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/watcher-troubleshooting
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Troubleshoot Watcher
## Dynamic mapping error when trying to add a watch

If you get the *Dynamic Mapping is Disabled* error when you try to add a watch, verify that the index mappings for the `.watches` index are available. You can do that by submitting the following request:
```json
```

If the index mappings are missing, follow these steps to restore the correct mappings:
1. Stop the Elasticsearch node.
2. Add `xpack.watcher.index.rest.direct_access : true` to [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings).
3. Restart the Elasticsearch node.
4. Delete the `.watches` index:
   ```json
   ```
5. Disable direct access to the `.watches` index:
   1. Stop the Elasticsearch node.
2. Remove `xpack.watcher.index.rest.direct_access : true` from [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings).
3. Restart the Elasticsearch node.


## Unable to send email

If you get an authentication error indicating that you need to continue the sign-in process from a web browser when Watcher attempts to send email, you need to configure Gmail to [Allow Less Secure Apps to access your account](https://support.google.com/accounts/answer/6010255?hl=en).
If you have two-step verification enabled for your email account, you must generate and use an App Specific password to send email from Watcher. For more information, see:
- Gmail: [Sign in using App Passwords](https://support.google.com/accounts/answer/185833?hl=en)
- Outlook.com: [App passwords and two-step verification](http://windows.microsoft.com/en-us/windows/app-passwords-two-step-verification)


## Watcher not responsive

Keep in mind that there’s no built-in validation of scripts that you add to a watch. Buggy or deliberately malicious scripts can negatively impact Watcher performance. For example, if you add multiple watches with buggy script conditions in a short period of time, Watcher might be temporarily unable to process watches until the bad watches time out.