﻿---
title: Troubleshoot searches
description: When you query your data, Elasticsearch might return an error, no search results, or results in an unexpected order. This guide describes how to troubleshoot...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/troubleshooting-searches
products:
  - Elastic Cloud Serverless
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Troubleshoot searches
When you query your data, Elasticsearch might return an error, no search results, or results in an unexpected order. This guide describes how to troubleshoot searches.

## Ensure the data stream, index, or alias exists

Elasticsearch returns an `index_not_found_exception` when the data stream, index or alias you try to query does not exist. This can happen when you misspell the name or when the data has been indexed to a different data stream or index.
Use the [exists API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-exists) to check whether a data stream, index, or alias exists:
```json
```

Use the [data stream stats API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-data-streams-stats-1) to list all data streams:
```json
```

Use the [get index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get) to list all indices and their aliases:
```json
```

Instead of an error, it is possible to retrieve partial search results if some of the indices you’re querying are unavailable. Set `ignore_unavailable` to `true`:
```json
```


## Ensure the data stream or index contains data

When a search request returns no hits, the data stream or index may contain no data. This can happen when there is a data ingestion issue. For example, the data may have been indexed to a data stream or index with another name.
Use the [count API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-count) to retrieve the number of documents in a data stream or index. Check that `count` in the response is not 0.
```json
```

<note>
  When getting no search results in Kibana, check that you have selected the correct data view and a valid time range. Also, ensure the data view has been configured with the correct time field.
</note>


## Check that the field exists and its capabilities

Querying a field that does not exist will not return any results. Use the [field capabilities API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-field-caps) to check whether a field exists:
```json
```

If the field does not exist, check the data ingestion process. The field may have a different name.
If the field exists, the request will return the field’s type and whether it is searchable and aggregatable.
```json
{
  "indices": [
    "my-index-000001"
  ],
  "fields": {
    "my-field": {
      "keyword": {
        "type": "keyword",         
        "metadata_field": false,
        "searchable": true,        
        "aggregatable": true       
      }
    }
  }
}
```


## Check the field’s mappings

A field’s capabilities are determined by its [mapping](https://www.elastic.co/docs/manage-data/data-store/mapping). To retrieve the mapping, use the [get mapping API](https://www.elastic.co/docs/manage-data/data-store/mapping):
```json
```

If you query a `text` field, pay attention to the analyzer that may have been configured. You can use the [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) to check how a field’s analyzer processes values and query terms:
```json

{
  "field" : "my-field",
  "text" : "this is a test"
}
```

To change the mapping of an existing field, refer to [Changing the mapping of a field](/docs/manage-data/data-store/mapping#updating-field-mappings).

## Check the field’s values

Use the [`exists` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-exists-query) to check whether there are documents that return a value for a field. Check that `count` in the response is not 0.
```json

{
  "query": {
    "exists": {
      "field": "my-field"
    }
  }
}
```

If the field is aggregatable, you can use [aggregations](https://www.elastic.co/docs/explore-analyze/query-filter/aggregations) to check the field’s values. For `keyword` fields, you can use a [terms aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-terms-aggregation) to retrieve the field’s most common values:
```json

{
  "size": 0,
  "aggs": {
    "top_values": {
      "terms": {
        "field": "my-field",
        "size": 10
      }
    }
  }
}
```

For numeric fields, you can use the [stats aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-stats-aggregation) to get an idea of the field’s value distribution:
```json

{
  "aggs": {
    "my-num-field-stats": {
      "stats": {
        "field": "my-num-field"
      }
    }
  }
}
```

If the field does not return any values, check the data ingestion process. The field may have a different name.

## Check the latest value

For time-series data, confirm there is non-filtered data within the attempted time range. For example, if you are trying to query the latest data for the `@timestamp` field, run the following to see if the max `@timestamp` falls within the attempted range:
```json
```


## Validate, explain, and profile queries

When a query returns unexpected results, Elasticsearch offers several tools to investigate why.
The [validate API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-validate-query) enables you to validate a query. Use the `rewrite` parameter to return the Lucene query an Elasticsearch query is rewritten into:
```json

{
  "query": {
    "match": {
      "user.id": {
        "query": "kimchy",
        "fuzziness": "auto"
      }
    }
  }
}
```

Use the [explain API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-explain) to find out why a specific document matches or doesn’t match a query:
```json

{
  "query" : {
    "match" : { "message" : "elasticsearch" }
  }
}
```

The [profile API](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/search-profile) provides detailed timing information about a search request. For a visual representation of the results, use the [Search Profiler](https://www.elastic.co/docs/explore-analyze/query-filter/tools/search-profiler) in Kibana.
<note>
  To troubleshoot queries in Kibana, select **Inspect** in the toolbar. Next, select **Request**. You can now copy the query Kibana sent to Elasticsearch for further analysis in Console.
</note>


## Check index settings

[Index settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings) can influence search results. For example, the `index.query.default_field` setting, which determines the field that is queried when a query specifies no explicit field. Use the [get index settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-settings) to retrieve the settings for an index:
```json
```

You can update dynamic index settings with the [update index settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-settings). [Changing dynamic index settings for a data stream](/docs/manage-data/data-store/data-streams/modify-data-stream#change-dynamic-index-setting-for-a-data-stream) requires changing the index template used by the data stream.
For static settings, you need to create a new index with the correct settings. Next, you can reindex the data into that index. For data streams, refer to [Change a static index setting for a data stream](/docs/manage-data/data-store/data-streams/modify-data-stream#change-static-index-setting-for-a-data-stream).

## Find slow queries

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

[Slow logs](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/slow-logs) can help pinpoint slow performing search requests. Enabling [audit logging](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/auding-settings) on top can help determine query source. Add the following settings to the [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) configuration file to trace queries. The resulting logging is verbose, so disable these settings when not troubleshooting.
```yaml
xpack.security.audit.enabled: true
xpack.security.audit.logfile.events.include: _all
xpack.security.audit.logfile.events.emit_request_body: true
```

Refer to [Advanced tuning: finding and fixing slow Elasticsearch queries](https://www.elastic.co/blog/advanced-tuning-finding-and-fixing-slow-elasticsearch-queries) for more information.