﻿---
title: Troubleshoot incomplete migration to data tiers
description: Elasticsearch standardized the implementation of hot-warm-cold architectures to data tiers in version 7.10. Some indices and deployments might have not...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/troubleshoot-migrate-to-tiers
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Troubleshoot incomplete migration to data tiers
Elasticsearch standardized the implementation of [hot-warm-cold architectures](https://www.elastic.co/blog/elasticsearch-data-lifecycle-management-with-data-tiers) to [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) in version 7.10. Some indices and deployments might have not fully transitioned to [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) and mix the new way of implementing the hot-warm-cold architecture with [legacy](https://www.elastic.co/docs/deploy-manage/distributed-architecture/shard-allocation-relocation-recovery/index-level-shard-allocation) based node attributes.
This could lead to unassigned shards or shards not transitioning to the desired [tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers).
To fix this issue, use the following steps.
You can run the following steps using either [API console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console) or direct [Elasticsearch API](https://www.elastic.co/docs/reference/elasticsearch/rest-apis) calls.
<tip>
  To learn how to assign tiers to your data nodes, refer to [Migrate index allocation filters to ILM node roles](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/migrate-index-allocation-filters-to-node-roles).
</tip>

To get the shards assigned, call the [migrate to data tiers routing](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) API, which resolves the conflicting routing configurations to using the standardized [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers). This also future-proofs the system by migrating the index templates and ILM policies if needed.
1. [Stop](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-stop) index lifecycle management
   ```json
   ```
   The response will look like this:
   ```json
   {
     "acknowledged": true
   }
   ```
2. Wait for index lifecycle management to stop. Check the status until it returns `STOPPED` as follows:
   ```json
   ```
   When index lifecycle management has successfully stopped the response will look like this:
   ```json
   {
     "operation_mode": "STOPPED"
   }
   ```
3. [Migrate to data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers)
   ```json
   ```
   The response will look like this:
   ```json
   {
     "dry_run": false,
     "migrated_ilm_policies":["policy_with_allocate_action"], 
     "migrated_indices":["warm-index-to-migrate-000001"], 
     "migrated_legacy_templates":["a-legacy-template"], 
     "migrated_composable_templates":["a-composable-template"], 
     "migrated_component_templates":["a-component-template"] 
   }
   ```
4. [Restart](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-start) index lifecycle management:
   ```json
   ```
   The response will look like this:
   ```json
   {
     "acknowledged": true
   }
   ```