﻿---
title: Troubleshoot snapshot and index lifecycle management
description: If the automatic snapshot lifecycle management (SLM) or index lifecycle management (ILM) service is not operating as expected, you might need to check...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/start-ilm
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Troubleshoot snapshot and index lifecycle management
If the automatic [snapshot lifecycle management](/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots#automate-snapshots-slm) (SLM) or [index lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) (ILM) service is not operating as expected, you might need to check its lifecycle status, stop, or restart the service. You may also want to halt services during routine maintenance.
You can perform the following procedures using either [API console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console) or direct [Elasticsearch API](https://www.elastic.co/docs/reference/elasticsearch/rest-apis) calls.

## Check status, stop, and restart SLM

Follow these steps to check the current SLM status, and to stop or restart it as needed.

### Get SLM status

To see the current status of the SLM service, use the [SLM status API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-slm-get-status):
```json
```

Under normal operation, the response shows SLM is `RUNNING`:
```json
{
  "operation_mode": "RUNNING"
}
```


### Stop SLM

You can stop snapshot lifecycle management to suspend management operations for all snapshots. For example, you might stop SLM to prevent it from taking scheduled snapshots during maintenance or when making cluster changes that could be impacted by snapshot operations.
To stop the SLM service and pause execution of all lifecycle policies, use the [SLM stop API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-slm-stop):
```json
```

Stopping SLM does not stop any snapshots that are in progress. You can manually trigger snapshots with the run snapshot lifecycle policy API even if SLM is stopped.
The response will look like this:
```json
{
  "acknowledged": true
}
```

Verify that snapshot lifecycle management has stopped:
```json
```

The response will look like this:
```json
{
  "operation_mode": "STOPPED"
}
```


### Start SLM

In the event that automatic snapshot lifecycle management is disabled, new backup snapshots will not be created automatically.
To restart the SLM service, use the [SLM start API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-slm-start).
```json
```

The response will look like this:
```json
{
  "acknowledged": true
}
```

Verify the snapshot lifecycle management is now running:
```json
```

The response will look like this:
```json
{
  "operation_mode": "RUNNING"
}
```


## Check status, stop, and restart ILM

Follow these steps to check the current ILM status, and to stop or restart it as needed.

### Get ILM status

To view the current status of the ILM service, use the [ILM status API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-get-status):
```json
```

Under normal operation, the response shows ILM is `RUNNING`:
```json
{
  "operation_mode": "RUNNING"
}
```

You can also [Check the ILM status of Elasticsearch indices and data streams](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/policy-view-status) for further information.

### Stop ILM

By default, the index lifecycle management service is in the `RUNNING` state and manages all indices that have lifecycle policies.
You can stop ILM to suspend management operations for all indices. For example, you might stop index lifecycle management when performing scheduled maintenance or making changes to the cluster that could impact the execution of ILM actions.
<important>
  When you stop ILM, [SLM](/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots#automate-snapshots-slm) operations are also suspended. SLM will not take snapshots as scheduled until you restart ILM. In-progress snapshots are not affected.
</important>

To stop the ILM service and pause execution of all lifecycle policies, use the [ILM stop API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-stop):
```json
```

The response looks like this:
```json
{
  "acknowledged": true
}
```

The ILM service runs all policies to a point where it is safe to stop.
While the ILM service is shutting down, run the status API to verify that ILM is stopping:
```json
```

The response looks like this:
```json
{
  "operation_mode": "STOPPING"
}
```

Once all policies are at a safe stopping point, ILM moves into the `STOPPED` mode:
```json
{
  "operation_mode": "STOPPED"
}
```


### Start ILM

If the automatic index lifecycle management or snapshot lifecycle management service is not working, you might need to restart the service.
To restart ILM and resume executing policies, use the [ILM start API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-start). This puts the  ILM service in the `RUNNING` state and ILM begins executing policies from where it left off.
```json
```

The response looks like this:
```json
{
  "acknowledged": true
}
```

Verify that index lifecycle management is now running:
```json
```

The response looks like this:
```json
{
  "operation_mode": "RUNNING"
}
```