﻿---
title: Diagnose password setup connection failures
description: The elasticsearch-setup-passwords command sets passwords for the built-in users by sending user management API requests. If your cluster uses SSL/TLS...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/security/trb-security-setup
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Diagnose password setup connection failures
The [elasticsearch-setup-passwords command](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/setup-passwords) sets passwords for the built-in users by sending user management API requests. If your cluster uses SSL/TLS for the HTTP (REST) interface, the command attempts to establish a connection with the HTTPS protocol. If the connection attempt fails, the command fails.
<admonition title="Deprecated in 8.0">
  The `elasticsearch-setup-passwords` tool is deprecated and will be removed in a future release. To manually reset the password for the built-in users (including the elastic user), use the [`elasticsearch-reset-password`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/reset-password) tool, the Elasticsearch [change password API](https://www.elastic.co/docs/api/doc/elasticsearch//operation/operation-security-change-password), or the [user management features](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native#managing-native-users) in Kibana.
</admonition>

**Symptoms:**
1. Elasticsearch is running HTTPS, but the command fails to detect it and returns the following errors:
   ```shell
   Cannot connect to elasticsearch node.
   java.net.SocketException: Unexpected end of file from server
   ...
   ERROR: Failed to connect to elasticsearch at
   http://127.0.0.1:9200/_security/_authenticate?pretty.
   Is the URL correct and elasticsearch running?
   ```
2. SSL/TLS is configured, but trust cannot be established. The command returns the following errors:
   ```shell
   SSL connection to
   https://127.0.0.1:9200/_security/_authenticate?pretty
   failed: sun.security.validator.ValidatorException:
   PKIX path building failed:
   sun.security.provider.certpath.SunCertPathBuilderException:
   unable to find valid certification path to requested target
   Check the elasticsearch SSL settings under
   xpack.security.http.ssl.
   ...
   ERROR: Failed to establish SSL connection to elasticsearch at
   https://127.0.0.1:9200/_security/_authenticate?pretty.
   ```
3. The command fails because hostname verification fails, which results in the following errors:
   ```shell
   SSL connection to
   https://idp.localhost.test:9200/_security/_authenticate?pretty
   failed: java.security.cert.CertificateException:
   No subject alternative DNS name matching
   elasticsearch.example.com found.
   Check the elasticsearch SSL settings under
   xpack.security.http.ssl.
   ...
   ERROR: Failed to establish SSL connection to elasticsearch at
   <ELASTICSEARCH_HOST_URL>:9200/_security/_authenticate?pretty.
   ```

**Resolution:**
1. If your cluster uses TLS/SSL for the HTTP interface but the `elasticsearch-setup-passwords` command attempts to establish a non-secure connection, use the `--url` command option to explicitly specify an HTTPS URL. Alternatively, set the `xpack.security.http.ssl.enabled` setting to `true`.
2. If the command does not trust the Elasticsearch server, verify that you configured the `xpack.security.http.ssl.certificate_authorities` setting or the `xpack.security.http.ssl.truststore.path` setting.
3. If hostname verification fails, you can disable this verification by setting `xpack.security.http.ssl.verification_mode` to `certificate`.

For more information about these settings, see [Security settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings).