﻿---
title: Fix errors: Invalid token or token expired in Elasticsearch
description: These errors occur when Elasticsearch receives a request containing an invalid or expired token during authentication. They're typically caused by missing,...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/security/token-invalid-expired
applies_to:
  - Elastic Stack: Generally available
---

# Fix errors: Invalid token or token expired in Elasticsearch
```json
Error: token expired
```

```json
Error: invalid token
```

These errors occur when Elasticsearch receives a request containing an invalid or expired token during authentication. They're typically caused by missing, incorrect, or outdated tokens. If an invalid or expired token is used, Elasticsearch rejects the request.

## Invalid token

Elasticsearch rejects requests with invalid authentication tokens. Common causes include:
- The token is expired or revoked
- The token format is incorrect or malformed
- The Authorization header is missing or doesn’t start with Bearer
- The client or middleware failed to attach the token properly
- Security settings in Elasticsearch are misconfigured

To resolve this error:
- Verify the token and ensure it's correctly formatted and current.
- Check expiration and generate a new token if needed.
- Inspect your client and confirm the token is sent in the `Authorization` header.
- Review Elasticsearch settings and check that token auth is enabled:
  ```yaml
  xpack.security.authc.token.enabled: true
  ```
- Use logs for details: Elasticsearch logs may provide context about the failure.


## Token expired

This error occurs when Elasticsearch receives a request containing an expired token during authentication.
To resolve this issue:
- Refresh the token, and obtain a new token using your token refresh workflow.
- Implement automatic token refresh and ensure your application is configured to refresh tokens before expiration.
- Avoid using expired tokens and do not reuse tokens after logout or expiration.
- Adjust token lifespan if needed and configure a longer token expiration in `elasticsearch.yml`, though this should be balanced against security needs:
  ```yaml
  xpack.security.authc.token.timeout: 20m
  ```