﻿---
title: Troubleshoot security in Elasticsearch
description: Use the information in this section to troubleshoot common problems and find answers for frequently asked questions. Troubleshoot a nodes info API response,...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/security
products:
  - Elasticsearch
---

# Troubleshoot security in Elasticsearch
Use the information in this section to troubleshoot common problems and find answers for frequently asked questions.
- [Troubleshoot a nodes info API response](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/security-trb-settings)
- [Troubleshoot authorization errors](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/security-trb-roles)
- [Error: Extra arguments were provided](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/security-trb-extraargs)
- [Troubleshoot Active Directory account lockout](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/trouble-shoot-active-directory)
- [Troubleshoot failed certificate verification with curl on Mac](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/trb-security-maccurl)
- [Troubleshoot SSLHandshakeException and failed node connections](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/trb-security-sslhandshake)
- [Common SSL/TLS exceptions](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/trb-security-ssl)
- [Common Kerberos exceptions](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/trb-security-kerberos)
- [Common SAML issues](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/trb-security-saml)
- [Internal server error in Kibana](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/trb-security-internalserver)
- [Diagnose password setup connection failures](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/trb-security-setup)
- [Diagnose configuration file location issues](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/trb-security-path)


## Additional resources

- [Troubleshooting overview](https://www.elastic.co/docs/troubleshoot)
- [Contact us](/docs/troubleshoot#contact-us)