﻿---
title: Restore from snapshot
description: This guide applies when one or more indices or data streams in your Elasticsearch cluster are missing or contain incomplete data, and you want to recover...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/restore-from-snapshot
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Restore from snapshot
This guide applies when one or more indices or data streams in your Elasticsearch cluster are missing or contain incomplete data, and you want to recover that data from an existing snapshot. [Snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore) store copies of your data outside the cluster.
Missing data can occur for several reasons, such as accidental deletion of indices or data streams, or node or disk failures when no replicas are configured. Depending on the cause, there are multiple ways to recover the data. Restoring from a snapshot is appropriate when a recent snapshot contains the affected indices or data streams.
<important>
  Restoring the missing data requires you to have a backup of the affected indices and data streams that is up-to-date enough for your use case. Don't proceed without confirming this.
</important>

To restore the indices and data streams with missing data, run the following steps using either [Kibana console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console) or direct [Elasticsearch API](https://www.elastic.co/docs/reference/elasticsearch/rest-apis) calls.
1. Review the affected indices using the [cat indices API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-indices).
   ```json
   ```
   The response will look like this:
   ```json
   index                                status health
   .ds-my-data-stream-2022.06.17-000001 open   red
   kibana_sample_data_flights           open   red
   ```
   The `red` health of the indices above indicates that these indices are missing primary shards, meaning they are missing data.
2. To restore the data we need to find a snapshot that contains these two indices. To find such a snapshot use the [get snapshot API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-get).
   ```json
   ```
   The response will look like this:
   ```json
   {
     "snapshots" : [
       {
         "snapshot" : "snapshot-20200617",                                     
         "uuid" : "dZyPs1HyTwS-cnKdH08EPg",
         "repository" : "my_repository",                                       
         "indices" : [                                                         
           ".apm-agent-configuration",
           ".apm-custom-link",
           ".ds-ilm-history-5-2022.06.17-000001",
           ".ds-my-data-stream-2022.06.17-000001",
           ".geoip_databases",
           ".kibana-event-log-8.2.2-000001",
           ".kibana_8.2.2_001",
           ".kibana_task_manager_8.2.2_001",
           "kibana_sample_data_ecommerce",
           "kibana_sample_data_flights",
           "kibana_sample_data_logs"
         ],
         "data_streams" : [ ],
         "state" : "SUCCESS"                                                     
       }
     ],
     "total" : 1,
     "remaining" : 0
   }
   ```
3. The snapshot `snapshot-20200617` contains the two indices we want to restore. You might have multiple snapshots from which you could restore the target indices. Choose the latest snapshot.
4. Now that we found a snapshot, we will proceed with the data stream preparation for restoring the lost data. We will check the index metadata to see if any index is part of a data stream:
   ```json
   ```
   The response will look like this:
   ```json
   {
     ".ds-my-data-stream-2022.06.17-000001" : {                                
       "aliases" : { },
       "mappings" : { },
       "settings" : {                                                          
         "index.creation_date" : "1658406121699",
         "index.hidden" : "true",
         "index.lifecycle.name" : "my-lifecycle-policy",
         "index.number_of_replicas" : "1",
         "index.number_of_shards" : "1",
         "index.provided_name" : ".ds-my-data-stream-2022.06.17-000001",
         "index.routing.allocation.include._tier_preference" : "data_hot",
         "index.uuid" : "HmlFXp6VSu2XbQ-O3hVrwQ",
         "index.version.created" : "8020299"
       },
       "data_stream" : "my-data-stream"                                        
     },
     "kibana_sample_data_flights" : {                                          
       "aliases" : { },
       "mappings" : { },
       "settings" : {
         "index.creation_date" : "1655121541454",
         "index.number_of_replicas" : "0",
         "index.number_of_shards" : "1",
         "index.provided_name" : "kibana_sample_data_flights",
         "index.routing.allocation.include._tier_preference" : "data_content",
         "index.uuid" : "jMOlwKPPSzSraeeBWyuoDA",
         "index.version.created" : "8020299"
       }
     }
   }
   ```
   The response above shows that `kibana_sample_data_flights` is not part of a data stream because it doesn’t have a field called `data_stream` in the settings.
   On the contrary, `.ds-my-data-stream-2022.06.17-000001` is part of the data stream called `my-data-stream`. When you find an index like this, which belongs to a data stream, you need to check if data are still being indexed. You can see that by checking the `settings`, if you can find this property: `"index.lifecycle.indexing_complete" : "true"`, it means that indexing is completed in this index and you can continue to the next step.
   If `index.lifecycle.indexing_complete` is not there or is configured to `false` you need to rollover the data stream so you can restore the missing data without blocking the ingestion of new data. The following command will achieve that.
   ```json
   ```
5. Now that the data stream preparation is done, we will close the target indices by using the [close indices API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-close).
   ```json
   ```
   You can confirm that they are closed with the [cat indices API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-indices).
   ```json
   ```
   The response will look like this:
   ```json
   index                                status health
   .ds-my-data-stream-2022.06.17-000001 close   red
   kibana_sample_data_flights           close   red
   ```
6. The indices are closed, now we can restore them from snapshots without causing any complications using the [restore snapshot API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-restore):
   ```json

   {
     "indices": "kibana_sample_data_flights,.ds-my-data-stream-2022.06.17-000001", <1>
     "include_aliases": true                                                       <2>
   }
   ```
   <note>
   If any [feature states](/docs/deploy-manage/tools/snapshot-and-restore#feature-state) need to be restored we’ll need to specify them using the `feature_states` field and the indices that belong to the feature states we restore must not be specified under `indices`. The [Health API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-health-report) returns both the `indices` and `feature_states` that need to be restored for the restore from snapshot diagnosis. e.g.:
   </note>
   ```json

   {
     "feature_states": [ "geoip" ],
     "indices": "kibana_sample_data_flights,.ds-my-data-stream-2022.06.17-000001",
     "include_aliases": true
   }
   ```
7. Finally we can verify that the indices health is now `green` via the [cat indices API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-indices).
   ```json
   ```
   The response will look like this:
   ```json
   index                                status health
   .ds-my-data-stream-2022.06.17-000001 open   green
   kibana_sample_data_flights           open   green
   ```
   As we can see above the indices are `green` and open. The issue is resolved.

For additional information about creating and restoring snapshots, refer to the [Snapshot and restore](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore) documentation.