﻿---
title: Rejected requests
description: When Elasticsearch rejects a request, it stops the operation and returns an error with a 429 response code. Rejected requests are commonly caused by: 
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/rejected-requests
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Rejected requests
When Elasticsearch rejects a request, it stops the operation and returns an error with a `429` response code. Rejected requests are commonly caused by:
- A [depleted thread pool](https://www.elastic.co/docs/troubleshoot/elasticsearch/high-cpu-usage). A depleted `search` or `write` thread pool returns a `TOO_MANY_REQUESTS` error message.
- A [circuit breaker error](https://www.elastic.co/docs/troubleshoot/elasticsearch/circuit-breaker-errors).
- High [indexing pressure](https://www.elastic.co/docs/reference/elasticsearch/index-settings/pressure) that exceeds the [`indexing_pressure.memory.limit`](https://www.elastic.co/docs/reference/elasticsearch/index-settings/pressure#memory-limits).

<admonition title="Simplify monitoring with AutoOps">
  AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths. Learn more about [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops).
</admonition>


## Check rejected tasks

To check the number of rejected tasks for each thread pool, use the [cat thread pool API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-thread-pool). A high ratio of `rejected` to `completed` tasks, particularly in the `search` and `write` thread pools, means Elasticsearch regularly rejects requests.
```json
```

`write` thread pool rejections frequently appear in the erring API and correlating log as `EsRejectedExecutionException` with either `QueueResizingEsThreadPoolExecutor` or `queue capacity`.
These errors are often related to [backlogged tasks](https://www.elastic.co/docs/troubleshoot/elasticsearch/task-queue-backlog).
See [this video](https://www.youtube.com/watch?v=auZJRXoAVpI) for a walkthrough of troubleshooting threadpool rejections.

## Check circuit breakers

To check the number of tripped [circuit breakers](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/circuit-breaker-settings), use the [node stats API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-nodes-stats).
```json
```

These statistics are cumulative from node startup. For more information, see [circuit breaker errors](https://www.elastic.co/docs/troubleshoot/elasticsearch/circuit-breaker-errors).
See [this video](https://www.youtube.com/watch?v=k3wYlRVbMSw) for a walkthrough of diagnosing circuit breaker errors.

## Check indexing pressure

To check the number of [indexing pressure](https://www.elastic.co/docs/reference/elasticsearch/index-settings/pressure) rejections, use the [node stats API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-nodes-stats).
```json
```

These stats are cumulative from node startup.
Indexing pressure rejections appear as an `EsRejectedExecutionException`, and indicate that they were rejected due to `combined_coordinating_and_primary`, `coordinating`, `primary`, or `replica`.
These errors are often related to [backlogged tasks](https://www.elastic.co/docs/troubleshoot/elasticsearch/task-queue-backlog), [bulk index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-bulk) sizing, or the ingest target's [`refresh_interval` setting](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules).
<note>
  <applies-to>Elastic Stack: Generally available since 9.1</applies-to><applies-to>Elastic Cloud Serverless: Generally available</applies-to>
  Another cause of indexing pressure rejections might be the use of the [`semantic_text`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text) field type, which can cause rejections when indexing large batches of documents if the batch may otherwise incur an Out of Memory (OOM) error.
</note>

See [this video](https://www.youtube.com/watch?v=QuV8QqSfc0c) for a walkthrough of diagnosing indexing pressure rejections.

## Prevent rejected requests


### Fix high CPU and memory usage

If Elasticsearch regularly rejects requests and other tasks, your cluster likely has high CPU usage or high JVM memory pressure. For tips, see [High CPU usage](https://www.elastic.co/docs/troubleshoot/elasticsearch/high-cpu-usage) and [High JVM memory pressure](https://www.elastic.co/docs/troubleshoot/elasticsearch/high-jvm-memory-pressure).

### Fix for `semantic_text` ingestion issues

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
</applies-to>

When bulk indexing documents with the `semantic_text` field type, you may encounter rejections due to high memory usage during inference processing.
These rejections will appear as an `InferenceException` in your cluster logs.
**To resolve this issue:**
1. Reduce the batch size of documents in your indexing requests.
2. If reducing batch size doesn't resolve the issue, then consider scaling up your machine resources.
3. <applies-to>Elastic Cloud Serverless: Unavailable</applies-to> A last resort option is to adjust the `indexing_pressure.memory.coordinating.limit` cluster setting. The default value is 10% of the heap. Increasing this limit allows more memory to be used for coordinating operations before rejections occur.

<warning>
  This adjustment should only be considered after exhausting other options, as setting this value too high may risk Out of Memory (OOM) errors in your cluster. A cluster restart is required for this change to take effect.
</warning>