﻿---
title: Red or yellow cluster health status
description: A red or yellow cluster health status indicates one or more shards are not assigned to a node. Red health status: The cluster has some unassigned primary...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/red-yellow-cluster-status
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Red or yellow cluster health status
A red or yellow cluster health status indicates one or more shards are not assigned to a node.
- **Red health status**: The cluster has some unassigned primary shards, which means that some operations such as searches and indexing may fail.
- **Yellow health status**: The cluster has no unassigned primary shards but some unassigned replica shards. This increases your risk of data loss and can degrade cluster performance.

When your cluster has a red or yellow health status, it will continue to process searches and indexing where possible, but may delay certain management and cleanup activities until the cluster returns to green health status. For instance, some [ILM](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) actions require the index on which they operate to have a green health status.
In many cases, your cluster will recover to green health status automatically. If the cluster doesn’t automatically recover, then you must [manually address](#fix-red-yellow-cluster-status) the remaining problems so management and cleanup activities can proceed. See [this video](https://www.youtube.com/watch?v=v2mbeSd1vTQ) for a walkthrough of monitoring allocation health.
<admonition title="Simplify monitoring with AutoOps">
  AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths. Learn more about [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops).
</admonition>


## Diagnose your cluster status

**Check your cluster status**
Use the [cluster health API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-health).
```json
```

A healthy cluster has a green `status` and zero `unassigned_shards`. A yellow status means only replicas are unassigned. A red status means one or more primary shards are unassigned.
<tip applies-to="Elastic Cloud Hosted: Generally available, Elastic Cloud Enterprise: Generally available">
  For Elastic Cloud Enterprise and Elastic Cloud Hosted deployments, you can also check cluster health from the deployment's **Monitoring** page in the Elastic Cloud Console or ECE Cloud UI. The Monitoring page provides detailed information on health issues, impacted areas, and troubleshooting support. Refer to [Cloud deployment health](/docs/deploy-manage/monitor/cloud-health-perf#ec-es-cluster-health) for more information.
</tip>

**View unassigned shards**
To view unassigned shards, use the [cat shards API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-shards).
```json
```

Unassigned shards have a `state` of `UNASSIGNED`. The `prirep` value is `p` for primary shards and `r` for replicas.
To understand why an unassigned shard is not being assigned and what action you must take to allow Elasticsearch to assign it, use the [cluster allocation explanation API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-allocation-explain).
```json

{
  "index": "my-index",
  "shard": 0,
  "primary": false
}
```

For common API response examples, see [Using the cluster allocation API for troubleshooting](https://www.elastic.co/docs/troubleshoot/elasticsearch/cluster-allocation-api-examples).

## Fix a red or yellow cluster status

A shard can become unassigned for several reasons. The following tips outline the most common causes and their solutions.

### Single node cluster

Elasticsearch will never assign a replica to the same node as the primary shard. A single-node cluster will always have yellow status. To change to green, set [number_of_replicas](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules#dynamic-index-number-of-replicas) to 0 for all indices. Only do this if you understand the impact of running without replicas (reduced fault tolerance and recovery options).
Therefore, if the number of replicas equals or exceeds the number of nodes, some shards won’t be allocated.

### Recover lost nodes

Shards often become unassigned when a data node leaves the cluster. This can occur for several reasons:
- A manual node restart will cause a temporary unhealthy cluster state until the node recovers.
- When a node becomes overloaded or fails, it can temporarily disrupt the cluster’s health, leading to an unhealthy state. Prolonged garbage collection (GC) pauses, caused by out-of-memory errors or high memory usage during intensive searches, can trigger this state. See [Reduce JVM memory pressure](#fix-cluster-status-jvm) for more JVM-related issues.
- Network issues can prevent reliable node communication, causing shards to become out of sync. Check the logs for repeated messages about nodes leaving and rejoining the cluster.

After you resolve the issue and recover the node, it will rejoin the cluster. Elasticsearch will then automatically allocate any unassigned shards.
You can monitor this process by [checking your cluster health](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-health). The number of unallocated shards should progressively decrease until green status is reached.
To avoid wasting resources on temporary issues, Elasticsearch [delays allocation](https://www.elastic.co/docs/deploy-manage/distributed-architecture/shard-allocation-relocation-recovery/delaying-allocation-when-node-leaves) by one minute by default. If you’ve recovered a node and don’t want to wait for the delay period, you can call the [cluster reroute API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-reroute) with no arguments to start the allocation process. The process runs asynchronously in the background.
```json
```


### Fix allocation settings

Misconfigured allocation settings can result in an unassigned primary shard. These settings include:
- [Shard allocation](https://www.elastic.co/docs/deploy-manage/distributed-architecture/shard-allocation-relocation-recovery/index-level-shard-allocation) index settings
- [Allocation filtering](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#cluster-shard-allocation-filtering) cluster settings
- [Allocation awareness](https://www.elastic.co/docs/deploy-manage/distributed-architecture/shard-allocation-relocation-recovery/shard-allocation-awareness) cluster settings

To review your allocation settings, use the [get index settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-settings) and [cluster get settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-get-settings) APIs.
```json
```

You can change the settings using the [update index settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-settings) and [cluster update settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings) APIs.

### Allocate or reduce replicas

To protect against hardware failure, Elasticsearch will not assign a replica to the same node as its primary shard. If no other data nodes are available to host the replica, it remains unassigned. To fix this, you can:
- Add a data node to the same tier to host the replica.
- Change the `index.number_of_replicas` index setting to reduce the number of replicas for each primary shard. We recommend keeping at least one replica per primary for high availability.

```json

{
  "index.number_of_replicas": 1
}
```


### Free up or increase disk space

Elasticsearch uses a [low disk watermark](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#disk-based-shard-allocation) to ensure data nodes have enough disk space for incoming shards. By default, Elasticsearch does not allocate shards to nodes using more than 85% of disk space.
To check the current disk space of your nodes, use the [cat allocation API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-allocation).
```json
```

If your nodes are running low on disk space, you have a few options:
- Upgrade your nodes to increase disk space.
- Add more nodes to the cluster.
- Delete unneeded indices to free up space. If you use ILM, you can update your lifecycle policy to use [searchable snapshots](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-searchable-snapshot) or add a delete phase. If you no longer need to search the data, you can use a [snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore) to store it off-cluster.
- If you no longer write to an index, use the [force merge API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-forcemerge) or ILM's [force merge action](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-forcemerge) to merge its segments into larger ones.
  ```json
  ```
- If an index is read-only, use the [shrink index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-shrink) or ILM's [shrink action](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-shrink) to reduce its primary shard count.
  ```json
  ```
- If your node has a large disk capacity, you can increase the low disk watermark or set it to an explicit byte value.
  ```json

  {
    "persistent": {
      "cluster.routing.allocation.disk.watermark.low": "90%",
      "cluster.routing.allocation.disk.watermark.high": "95%"
    }
  }
  ```

<important>
  Increasing this watermark is usually a temporary solution and may cause instability if disk space is not freed up.
</important>


### Re-enable shard allocation

You typically disable shard allocation during a [restart](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/full-cluster-restart-rolling-restart-procedures) or other cluster maintenance to prevent a recovery cascade while a node is temporarily out of the cluster. If allocation is not re-enabled afterward, Elasticsearch cannot assign shards.
Verify whether allocation is disabled using the [cluster settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-get-settings):
```json
```

If allocation is not enabled, the response shows an override from the default value at either the `persistent` or `transient` level, for example:
```
{
  "persistent": {
    "cluster": {"routing": {"allocation": {"enable": "none" } } }
  },
  "defaults": {
    "cluster": {"routing": {"allocation": {"enable": "all" } } } }
}
```

<note>
  Setting [`cluster.routing.allocation.enable`](https://www.elastic.co/docs/troubleshoot/elasticsearch/allow-all-cluster-allocation) only affects shard allocations going forward but does not affect current allocations. So overriding this to `none` does not block existing ingestion. However, new indices cannot be created when overrode, including indices induced from [ILM Rollover](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-rollover).
</note>

To re-enable allocation, reset the `cluster.routing.allocation.enable` cluster setting:
```json

{
  "persistent" : {
    "cluster.routing.allocation.enable" : null
  }
}
```

After re-enabling allocation, the cluster automatically resumes shard assignment, recovery, and rebalancing. You can verify this using the [cluster health API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-health):
```json
```

See [this video](https://www.youtube.com/watch?v=MiKKUdZvwnI) for walkthrough of troubleshooting "no allocations are allowed".

### Reduce JVM memory pressure

Shard allocation requires JVM heap memory. High JVM memory pressure can trigger [circuit breakers](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/circuit-breaker-settings) that stop allocation and leave shards unassigned. See [High JVM memory pressure](https://www.elastic.co/docs/troubleshoot/elasticsearch/high-jvm-memory-pressure).

### Recover data for a lost primary shard

If a node containing a primary shard is lost, Elasticsearch can typically replace it using a replica on another node. If you can’t recover the node and replicas don’t exist or are irrecoverable, [Allocation Explain](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-allocation-explain) will report `no_valid_shard_copy` and you’ll need to do one of the following:
- restore the missing data from [snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore)
- index the missing data from its original data source
- accept data loss on the index-level by running [Delete Index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-delete)
- accept data loss on the shard-level by executing [Cluster Reroute](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-reroute) allocate_stale_primary or allocate_empty_primary command with `accept_data_loss: true`
  <warning>
  Only use this option if node recovery is no longer possible. This process allocates an empty primary shard. If the node later rejoins the cluster, Elasticsearch will overwrite its primary shard with data from this newer empty shard, resulting in data loss.
  </warning>
  ```json

  {
    "commands": [
      {
        "allocate_empty_primary": {
          "index": "my-index",
          "shard": 0,
          "node": "my-node",
          "accept_data_loss": "true"
        }
      }
    ]
  }
  ```

See [this video](https://www.youtube.com/watch?v=6OAg9IyXFO4) for a walkthrough of troubleshooting `no_valid_shard_copy`.