﻿---
title: Troubleshoot monitoring
description: Use the information in this section to troubleshoot common problems and find answers for frequently asked questions. See also Troubleshooting monitoring...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/monitoring-troubleshooting
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Troubleshoot monitoring
Use the information in this section to troubleshoot common problems and find answers for frequently asked questions. See also [Troubleshooting monitoring in Logstash](https://www.elastic.co/docs/reference/logstash/monitoring-troubleshooting).
<tip>
  If you can't find your issue here, explore the other [troubleshooting topics](https://www.elastic.co/docs/troubleshoot) or [contact us](/docs/troubleshoot#contact-us).
</tip>

<admonition title="Simplify monitoring with AutoOps">
  AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths. Learn more about [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops).
</admonition>


## No monitoring data is visible in Kibana

**Symptoms**: There is no information about your cluster on the **Stack Monitoring** page in Kibana.
**Resolution**: Check whether the appropriate indices exist on the monitoring cluster. For example, use the [cat indices](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-indices) command to verify that there is a `.monitoring-kibana*` index for your Kibana monitoring data and a `.monitoring-es*` index for your Elasticsearch monitoring data. If you are collecting monitoring data by using Metricbeat the indices have `-mb` in their names. If the indices do not exist, review your configuration. For example, see [Enable stack monitoring for Elasticsearch on a self-managed cluster](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/elasticsearch-monitoring-self-managed).

## Monitoring data for some Elastic Stack nodes or instances is missing from Kibana

**Symptoms**: The **Stack Monitoring** page in Kibana does not show information for some nodes or instances in your cluster.
**Resolution**: Verify that the missing items have unique UUIDs. Each Elasticsearch node, Logstash node, Kibana instance, Beat instance, and APM Server is considered unique based on its persistent UUID, which is found in its `path.data` directory. Alternatively, you can find the UUIDs in the product logs at startup.
In some cases, you can also retrieve this information via APIs:
- For Beat instances, use the HTTP endpoint to retrieve the `uuid` property. For example, refer to [Configure an HTTP endpoint for Filebeat metrics](https://www.elastic.co/docs/reference/beats/filebeat/http-endpoint).
- For Kibana instances, use the [status endpoint](https://www.elastic.co/docs/troubleshoot/kibana/access) to retrieve the `uuid` property.
- For Logstash nodes, use the [monitoring APIs root resource](https://www.elastic.co/docs/reference/logstash/monitoring-logstash) to retrieve the `id` property.

<tip>
  When you install Elasticsearch, Logstash, Kibana, APM Server, or Beats, their `path.data` directory should be non-existent or empty; do not copy this directory from other installations.
</tip>