﻿---
title: Fix other role nodes out of disk
description: Elasticsearch can use dedicated nodes to execute other functions apart from storing data or coordinating the cluster, for example machine learning. If...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/fix-other-node-out-of-disk
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Fix other role nodes out of disk
Elasticsearch can use dedicated nodes to execute other functions apart from storing data or coordinating the cluster, for example machine learning. If one or more of these nodes are running out of space, you need to ensure that they have enough disk space to function. If the [health API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-health-report) reports that a node that is not a master and does not contain data is out of space you need to increase the disk capacity of this node.
<applies-switch>
  <applies-item title="{ ece:, ess: }" applies-to="Elastic Cloud Hosted: Generally available, Elastic Cloud Enterprise: Generally available">
    <warning applies-to="Elastic Cloud Enterprise: Generally available">
      In ECE, resizing is limited by your [allocator capacity](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-manage-capacity).
    </warning>

    1. Log in to the [Elastic Cloud console](https://cloud.elastic.co?page=docs&placement=docs-body) or ECE Cloud UI.
    2. On the home page, find your deployment and select **Manage**.
    3. Go to **Actions** > **Edit deployment** and then go to the **Coordinating instances** or the **Machine Learning instances** section depending on the roles listed in the diagnosis:
       ![](https://www.elastic.co/docs/troubleshoot/images/elasticsearch-reference-increase-disk-capacity-other-node.png)

    1. Choose a larger than the pre-selected capacity configuration from the drop-down menu and click `save`. Wait for the plan to be applied and the problem should be resolved.
  </applies-item>

  <applies-item title="{ eck:, self: }" applies-to="Elastic Cloud on Kubernetes: Generally available, Self-managed Elastic deployments: Generally available">
    To increase the disk capacity of any other node, you need to replace the instance that has run out of space with one of higher disk capacity.
    1. First, retrieve the disk threshold that indicates how much disk space is needed. The relevant threshold is the [high watermark](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#cluster-routing-watermark-high) and can be retrieved using the following command:
       ```json
       ```
       The response looks like this:
       ```json
       {
         "defaults": {
           "cluster": {
             "routing": {
               "allocation": {
                 "disk": {
                   "watermark": {
                     "high": "90%",
                     "high.max_headroom": "150GB"
                   }
                 }
               }
             }
           }
         }
       ```
       This response means that, to resolve the disk shortage, you need to either drop our disk usage below the 90% or have more than 150GB available. [Read more how this threshold works](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#cluster-routing-watermark-high).
    2. The next step is to find out the current disk usage. This information allows you to calculate how much extra space is needed. In the following example, we show only a machine learning node for readability purposes:
       ```json
       ```
       The response looks like this:
       ```json
       name                node.role disk.used_percent disk.used disk.avail disk.total
       instance-0000000000     l                 85.31    3.4gb     500mb       4gb
       ```
    3. The goal is to reduce disk usage below the relevant threshold, in our example 90%. Consider adding some padding so that usage doesn't immediately exceed the threshold again. Assuming you have the new node ready, add this node to the cluster.
    4. Verify that the new node has joined the cluster:
       ```json
       ```
       The response looks like this:
       ```json
       name                node.role disk.used_percent disk.used disk.avail disk.total
       instance-0000000000     l                 85.31    3.4gb     500mb       4gb
       instance-0000000001     l                 41.31    3.4gb     4.5gb       8gb
       ```
    5. Now you can remove the out of disk space instance.
  </applies-item>
</applies-switch>