﻿---
title: Fix common cluster issues
description: Use these topics to fix common issues with Elasticsearch clusters. Troubleshoot Elasticsearch, Troubleshooting overview. 
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/fix-common-cluster-issues
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Fix common cluster issues
Use these topics to fix common issues with Elasticsearch clusters.
<admonition title="Simplify monitoring with AutoOps">
  AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths. Learn more about [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops).
</admonition>

<definitions>
  <definition term="Watermark errors">
    Fix watermark errors that occur when a data node is critically low on disk space and has reached the flood-stage disk usage watermark.
  </definition>
  <definition term="Circuit breaker errors">
    Elasticsearch uses circuit breakers to prevent nodes from running out of JVM heap memory. If Elasticsearch estimates an operation would exceed a circuit breaker, it stops the operation and returns an error.
  </definition>
  <definition term="Symptom: High CPU usage">
    The most common causes of high CPU usage and their solutions.
  </definition>
  <definition term="High JVM memory pressure">
    High JVM memory usage can degrade cluster performance and trigger circuit breaker errors.
  </definition>
  <definition term="Red or yellow cluster health status">
    A red or yellow cluster status indicates one or more shards are missing or unallocated. These unassigned shards increase your risk of data loss and can degrade cluster performance.
  </definition>
  <definition term="Rejected requests">
    When Elasticsearch rejects a request, it stops the operation and returns an error with a `429` response code.
  </definition>
  <definition term="Task queue backlog">
    A backlogged task queue can prevent tasks from completing and put the cluster into an unhealthy state.
  </definition>
  <definition term="Mapping explosion">
    A cluster in which an index or index pattern as exploded with a high count of mapping fields which causes performance look-up issues for Elasticsearch and {kib}.
  </definition>
  <definition term="Hot spotting">
    Hot spotting can occur in Elasticsearch when resource utilizations are unevenly distributed across nodes.
  </definition>
</definitions>


## Additional resources

- [Troubleshoot Elasticsearch](https://www.elastic.co/docs/troubleshoot/elasticsearch)
- [Troubleshooting overview](https://www.elastic.co/docs/troubleshoot)