﻿---
title: Fix error: Failed to parse field
description: This error occurs when you try to index a document, but one of the field values doesn't match the expected data type. Elasticsearch rejects the document...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/failed-to-parse-field-of-type
applies_to:
  - Elastic Stack: Generally available
---

# Fix error: Failed to parse field
```json
Error: failed to parse field [field] of type [type] in document with id [id]
```

This error occurs when you try to index a document, but one of the field values doesn't match the expected data type. Elasticsearch rejects the document when it encounters incompatible values, like a string in a numeric field or an invalid IP address.
To fix this issue, make sure each field value matches the data type defined in the mapping.

## Field types and mapping

When no explicit mapping exists, Elasticsearch uses [dynamic mappings](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-field-mapping) to infer a field's type based on the **first value indexed**.
For example, if you index:
```json

{
  "ip_address": "179.152.62.82",
  "boolean_field": "off"
}
```

Without explicit mapping, Elasticsearch will treat `ip_address` and `boolean_field` as `text`, which might not be the intended result.
To avoid this, define the mapping explicitly:
```json

{
  "mappings": {
    "properties": {
      "ip_address": { "type": "ip" },
      "boolean_field": { "type": "boolean" }
    }
  }
}
```

To check the data type of the field causing the error, first get the mapping:
`console GET your-index-name/_mapping `
Make sure the incoming data matches the expected type. If not, you'll need to fix the data or update the mapping. If necessary, create a new index with the correct mapping and reindex your data.