﻿---
title: Diagnose unknown repositories
description: When a snapshot repository is marked as "unknown", it means that an Elasticsearch node is unable to instantiate the repository due to an unknown repository...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/diagnosing-unknown-repositories
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Diagnose unknown repositories
When a snapshot repository is marked as "unknown", it means that an Elasticsearch node is unable to instantiate the repository due to an unknown repository type. This is usually caused by a missing plugin on the node. Make sure each node in the cluster has the required plugins by following the following steps:
1. Retrieve the affected nodes from the affected resources section of the health report.
2. Use the [nodes info API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-nodes-info) to retrieve the plugins installed on each node.
3. Cross reference this with a node that works correctly to find out which plugins are missing and install the missing plugins.

Learn more about snapshot and restore plugins:
- [Available plugins](https://www.elastic.co/docs/reference/elasticsearch/plugins/plugin-management)
- [Installing plugins in self-managed clusters](https://www.elastic.co/docs/reference/elasticsearch/plugins/plugin-management)
- [Installing plugins on Elastic Cloud on Kubernetes](/docs/deploy-manage/tools/snapshot-and-restore/cloud-on-k8s#k8s-install-plugin)

<tip>
  Elastic Cloud Hosted and Elastic Cloud Enterprise only support specific repository types, which can't be extended using plugins. [Learn more](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore).
</tip>