﻿---
title: Diagnose unassigned shards
description: An unassigned shard is a shard that exists in the cluster metadata but is not currently allocated to any node, which means its data is unavailable for...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/diagnose-unassigned-shards
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Diagnose unassigned shards
<admonition title="Simplify monitoring with AutoOps">
  AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths. Learn more about [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops).
</admonition>

An unassigned shard is a shard that exists in the cluster metadata but is not currently allocated to any node, which means its data is unavailable for both search and indexing operations.
Shards can become unassigned for many reasons, such as node failures, cluster or indices configuration, insufficient resources, or allocation rules that prevent Elasticsearch from placing the shard on any available node.
Unassigned shards directly affects the cluster health status:
- If at least one replica shard is unassigned, the cluster health becomes yellow. The cluster can still serve all data, but redundancy is reduced.
- If at least one primary shard is unassigned, the cluster health becomes red. In this state, some data is unavailable, and affected indices cannot fully operate.

To diagnose the unassigned shards in your deployment, use the following steps. You can use either [API console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console), or direct [Elasticsearch API](https://www.elastic.co/docs/reference/elasticsearch/rest-apis) calls.
1. View the unassigned shards using the [cat shards API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-shards).
   ```json
   ```
   The response looks like this:
   ```json
   [
     {
       "index": "my-index-000001",
       "shard": "0",
       "prirep": "p",
       "state": "UNASSIGNED",
       "node": null,
       "unassigned.reason": "INDEX_CREATED"
     }
   ]
   ```
   Unassigned shards have a `state` of `UNASSIGNED`. The `prirep` value is `p` for primary shards and `r` for replicas.
   The index in the example has a primary shard unassigned.
2. To understand why an unassigned shard is not being assigned and what action you must take to allow Elasticsearch to assign it, use the [cluster allocation explanation API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-allocation-explain).
   ```json

   {
     "index": "my-index-000001", <1>
     "shard": 0, <2>
     "primary": true <3>
   }
   ```
   The response looks like this:
   ```json
   {
     "index" : "my-index-000001",
     "shard" : 0,
     "primary" : true,
     "current_state" : "unassigned",                 
     "unassigned_info" : {
       "reason" : "INDEX_CREATED",                   
       "at" : "2022-01-04T18:08:16.600Z",
       "last_allocation_status" : "no"
     },
     "can_allocate" : "no",                          
     "allocate_explanation" : "Elasticsearch isn't allowed to allocate this shard to any of the nodes in the cluster. Choose a node to which you expect this shard to be allocated, find this node in the node-by-node explanation, and address the reasons which prevent Elasticsearch from allocating this shard there.",
     "node_allocation_decisions" : [
       {
         "node_id" : "8qt2rY-pT6KNZB3-hGfLnw",
         "node_name" : "node-0",
         "transport_address" : "127.0.0.1:9401",
         "roles": ["data_content", "data_hot"],
         "node_attributes" : {},
         "node_decision" : "no",                     
         "weight_ranking" : 1,
         "deciders" : [
           {
             "decider" : "filter",                   
             "decision" : "NO",
             "explanation" : "node does not match index setting [index.routing.allocation.include] filters [_name:\"nonexistent_node\"]"  
           }
         ]
       }
     ]
   }
   ```
3. The explanation in our case indicates the index allocation configurations are not correct. To review your allocation settings, use the [get index settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-settings) and [cluster get settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-get-settings) APIs.
   ```json
   ```
4. Change the settings using the [update index settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-settings) and [cluster update settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings) APIs to the correct values to allow the index to be allocated.

For more guidance on fixing the most common causes for unassigned shards, follow [Red or yellow cluster health status > Fix a red or yellow cluster status](/docs/troubleshoot/elasticsearch/red-yellow-cluster-status#fix-red-yellow-cluster-status), refer to [Using the cluster allocation API for troubleshooting](https://www.elastic.co/docs/troubleshoot/elasticsearch/cluster-allocation-api-examples), or contact [Elastic Support](https://support.elastic.co).
Watch [this video](https://www.youtube.com/watch?v=v2mbeSd1vTQ) for a walkthrough of monitoring allocation health.

## Common issues

The following sections provide advice for resolving some of the common causes for unassigned shards.

### Conflicting settings

A primary shard might be unassigned due to conflicting settings.
View [this video](https://www.youtube.com/watch?v=5z3n2VgusLE) for a walkthrough of troubleshooting a node and index setting mismatch.

### Maximum number of retries exceeded

When Elasticsearch is unable to allocate a shard, it attempts to retry allocation up to the maximum number of retries allowed.
After this, Elasticsearch stops attempting to allocate the shard to prevent infinite retries, which might impact cluster performance.
You can use an API to [reroute the cluster](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-reroute), which allocates the shard if the issue preventing allocation has been resolved. For example:
```json
```


### No valid shard copy

If a shard is unassigned with an allocation status of `no_valid_shard_copy`, you should make sure that all nodes are in the cluster. If all the nodes containing in-sync copies of a shard are lost, then you can recover the data for the shard.
View [this video](https://www.youtube.com/watch?v=6OAg9IyXFO4) for a walkthrough of troubleshooting `no_valid_shard_copy`.