﻿---
title: Troubleshoot data issues in Elasticsearch
description: Use the topics in this section to troubleshoot data-related issues in your Elasticsearch deployments, including allocation problems, tiering issues, and...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/data
---

# Troubleshoot data issues in Elasticsearch
Use the topics in this section to troubleshoot data-related issues in your Elasticsearch deployments, including allocation problems, tiering issues, and shard limits.
- [Allow Elasticsearch to allocate the data in the system](https://www.elastic.co/docs/troubleshoot/elasticsearch/allow-all-cluster-allocation)
- [Allow Elasticsearch to allocate the index](https://www.elastic.co/docs/troubleshoot/elasticsearch/allow-all-index-allocation)
- [Add a preferred data tier to a deployment](https://www.elastic.co/docs/troubleshoot/elasticsearch/add-tier)
- [Troubleshoot incomplete migration to data tiers](https://www.elastic.co/docs/troubleshoot/elasticsearch/troubleshoot-migrate-to-tiers)
- [Warning: Not enough nodes to allocate all shard replicas](https://www.elastic.co/docs/troubleshoot/elasticsearch/increase-tier-capacity)
- [Total number of shards for an index on a single node exceeded](https://www.elastic.co/docs/troubleshoot/elasticsearch/increase-shard-limit)
- [Total number of shards per node has been reached](https://www.elastic.co/docs/troubleshoot/elasticsearch/increase-cluster-shard-limit)
- [Troubleshoot data corruption](https://www.elastic.co/docs/troubleshoot/elasticsearch/corruption-troubleshooting)


## Additional resources

- [Watermark errors](https://www.elastic.co/docs/troubleshoot/elasticsearch/fix-watermark-errors)
- [Troubleshooting overview](https://www.elastic.co/docs/troubleshoot)
- [Contact us](/docs/troubleshoot#contact-us)