﻿---
title: Allow Elasticsearch to allocate the index
description: The allocation of data can be controlled using the enable allocation configuration. In certain circumstances users might want to temporarily disable or...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/allow-all-index-allocation
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Allow Elasticsearch to allocate the index
The allocation of data can be controlled using the [enable allocation configuration](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules#index-routing-allocation-enable-setting). In certain circumstances users might want to temporarily disable or restrict the allocation of data.
Forgetting to re-allow all data allocation can lead to unassigned shards.
In order to get the shards assigned we’ll need to change the value of the [configuration](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules#index-routing-allocation-enable-setting) that restricts the assignment of the shards to `all`.
To allow all data to be allocated, follow these steps.
You can run the following steps using either [API console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console) or direct [Elasticsearch API](https://www.elastic.co/docs/reference/elasticsearch/rest-apis) calls.
1. Inspect the `index.routing.allocation.enable` [index setting](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-settings) for the index with unassigned shards:
   ```json
   ```
   The response will look like this:
   ```json
   {
     "my-index-000001": {
       "settings": {
         "index.routing.allocation.enable": "none" 
       }
     }
   }
   ```
2. [Change](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-settings) the [configuration](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules#index-routing-allocation-enable-setting) value to allow the index to be fully allocated:
   ```json

   {
     "index" : {
       "routing.allocation.enable" : "all" <1>
     }
   }
   ```