﻿---
title: Allow Elasticsearch to allocate the data in the system
description: The allocation of data in an Elasticsearch deployment can be controlled using the enable cluster allocation configuration. In certain circumstances users...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/allow-all-cluster-allocation
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Allow Elasticsearch to allocate the data in the system
The allocation of data in an Elasticsearch deployment can be controlled using the [enable cluster allocation configuration](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#cluster-routing-allocation-enable). In certain circumstances users might want to temporarily disable or restrict the allocation of data in the system.
Forgetting to re-allow all data allocations can lead to unassigned shards.
To get the shards assigned we need to change the value of the [configuration](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#cluster-routing-allocation-enable) that restricts the assignment of the shards to allow all shards to be allocated.
We achieve this by inspecting the system-wide `cluster.routing.allocation.enable` [cluster setting](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-get-settings) and changing the configured value to `all`.
To allow all data to be allocated, follow these steps.
You can run the following steps using either [API console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console) or direct [Elasticsearch API](https://www.elastic.co/docs/reference/elasticsearch/rest-apis) calls.
1. Inspect the `cluster.routing.allocation.enable` [cluster setting](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-get-settings):
   ```json
   ```
   The response will look like this:
   ```json
   {
     "persistent": {
       "cluster.routing.allocation.enable": "none" 
     },
     "transient": {}
   }
   ```
2. [Change](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings) the [configuration](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#cluster-routing-allocation-enable) value to allow all the data in the system to be fully allocated:
   ```json

   {
     "persistent" : {
       "cluster.routing.allocation.enable" : "all" <1>
     }
   }
   ```