﻿---
title: Add a preferred data tier to a deployment
description: In an Elasticsearch deployment, an index and its shards can be allocated to data tiers using routing and allocation settings. Different data tiers are...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch/add-tier
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Add a preferred data tier to a deployment
In an Elasticsearch deployment, an index and its shards can be allocated to [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) using routing and allocation settings.
Different data tiers are optimized for specific workloads. For example, the hot tier is optimized for frequent writes and queries, while the warm tier for less frequent access. Adding a preferred tier ensures that data is stored on nodes with the appropriate hardware and performance characteristics.
When indices have specific tier preferences, shards may remain unallocated if there are no nodes available in the preferred tier. Adding a preferred data tier ensures that the shards can be allocated to the appropriate nodes.
To allow indices to be allocated, follow these steps:
1. [Determine which tiers](#determine-target-tier) an index's shards can be allocated to.
2. [Resize your deployment](#resize-your-deployment) to add resources to the required tier.


## Determine the target tier

You can run the following step using either [API console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console) or direct [Elasticsearch API](https://www.elastic.co/docs/reference/elasticsearch/rest-apis) calls.
Use the [get index settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-settings) API to retrieve the configured value for the `index.routing.allocation.include._tier_preference` setting:
```json
```

The response looks like this:
```json
{
  "my-index-000001": {
    "settings": {
      "index.routing.allocation.include._tier_preference": "data_warm,data_hot" 
    }
  }
}
```

1. Represents a comma-separated list of data tier node roles this index is allowed to be allocated on. The first tier in the list has the highest priority and is the tier the index is targeting. In this example, the tier preference is `data_warm,data_hot`, so the index is targeting the `warm` tier. If the warm tier lacks capacity, the index will fall back to the `data_hot` tier.


## Resize your deployment

<applies-switch>
  <applies-item title="{ ess:, ece: }" applies-to="Elastic Cloud Hosted: Generally available, Elastic Cloud Enterprise: Generally available">
    <warning applies-to="Elastic Cloud Enterprise: Generally available">
      In ECE, resizing is limited by your [allocator capacity](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-manage-capacity).
    </warning>
    To resize your deployment and increase its capacity by expanding a data tier or adding a new one, use the following options:**Option 1: Configure Autoscaling**
    1. Log in to the [Elastic Cloud console](https://cloud.elastic.co?page=docs&placement=docs-body) or ECE Cloud UI.
    2. On the home page, find your deployment and select **Manage**.
    3. Go to **Actions** > **Edit deployment** and check that autoscaling is enabled. Adjust the **Enable Autoscaling for** dropdown menu as needed and select **Save**.
    4. If autoscaling is successful, the cluster returns to a `healthy` status.
       If the cluster is still out of disk, check if autoscaling has reached its set limits and [update your autoscaling settings](/docs/deploy-manage/autoscaling/autoscaling-in-ece-and-ech#ec-autoscaling-update).
    **Option 2: Configure deployment size and tiers**You can increase the deployment capacity by editing the deployment and adjusting the size of the existing data tiers or adding new ones.
    1. In Kibana, open your deployment’s navigation menu (placed under the Elastic logo in the upper left corner) and go to **Manage this deployment**.
    2. From the right hand side, click to expand the **Manage** dropdown button and select **Edit deployment** from the list of options.
    3. On the **Edit** page, increase capacity for the data tier you identified earlier by either adding a new tier with **+ Add capacity** or adjusting the size of an existing one. Choose the desired size and availability zones for that tier.
    4. Navigate to the bottom of the page and click the **Save** button.
    **Option 3: Change the hardware profiles/deployment templates**You can change the [hardware profile](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/ec-change-hardware-profile) for Elastic Cloud Hosted deployments or [deployment template](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deployment-templates) of the Elastic Cloud Enterprise cluster to one with a higher disk-to-memory ratio.**Option 4: <applies-to>Elastic Cloud Enterprise: Generally available</applies-to> Override disk quota**Elastic Cloud Enterprise administrators can temporarily override the disk quota of Elasticsearch nodes in real time as explained in [Resource overrides](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/resource-overrides). We strongly recommend making this change only under the guidance of Elastic Support, and only as a temporary measure or for troubleshooting purposes.
  </applies-item>

  <applies-item title="{ self: }" applies-to="Self-managed Elastic deployments: Generally available">
    To increase the data node capacity in your cluster, you can [add more nodes](https://www.elastic.co/docs/deploy-manage/maintenance/add-and-remove-elasticsearch-nodes) to the cluster and assign the index’s target tier [node role](/docs/manage-data/lifecycle/data-tiers#configure-data-tiers-on-premise) to the new nodes, or increase the disk capacity of existing nodes. Disk expansion procedures depend on your operating system and storage infrastructure and are outside the scope of Elastic support. In practice, this is often achieved by [removing a node from the cluster](https://www.elastic.co/docs/deploy-manage/maintenance/add-and-remove-elasticsearch-nodes) and reinstalling it with a larger disk.
  </applies-item>

  <applies-item title="{ eck: }" applies-to="Elastic Cloud on Kubernetes: Generally available">
    To increase the capacity of the data nodes in your Elastic Cloud on Kubernetes cluster, you can either add more data nodes to the desired tier, or increase the storage size of existing nodes.**Option 1: Add more data nodes**
    1. Update the `count` field in your data node `nodeSets` to add more nodes:
       ```yaml
       apiVersion: elasticsearch.k8s.elastic.co/v1
       kind: Elasticsearch
       metadata:
         name: quickstart
       spec:
         version: 9.3.0
         nodeSets:
         - name: data-nodes
           count: 5 
           config:
             node.roles: ["data"]
           volumeClaimTemplates:
           - metadata:
               name: elasticsearch-data
             spec:
               accessModes:
               - ReadWriteOnce
               resources:
                 requests:
                   storage: 100Gi
       ```
    2. Apply the changes:
       ```sh
       kubectl apply -f your-elasticsearch-manifest.yaml
       ```
       ECK automatically creates the new nodes with a `data` [node role](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles) and Elasticsearch will relocate shards to balance the load.
       You can monitor the progress using:
       ```json
       ```
    **Option 2: Increase storage size of existing nodes**
    1. If your storage class supports [volume expansion](https://kubernetes.io/docs/concepts/storage/persistent-volumes/#expanding-persistent-volumes-claims), you can increase the storage size in the `volumeClaimTemplates`:
       ```yaml
       apiVersion: elasticsearch.k8s.elastic.co/v1
       kind: Elasticsearch
       metadata:
         name: quickstart
       spec:
         version: 9.3.0
         nodeSets:
         - name: data-nodes
           count: 3
           config:
             node.roles: ["data"]
           volumeClaimTemplates:
           - metadata:
               name: elasticsearch-data
             spec:
               accessModes:
               - ReadWriteOnce
               resources:
                 requests:
                   storage: 200Gi 
       ```
    2. Apply the changes. If the volume driver supports `ExpandInUsePersistentVolumes`, the filesystem will be resized online without restarting Elasticsearch. Otherwise, you might need to manually delete the Pods after the resize so they can be recreated with the expanded filesystem.
    For more information, refer to [Update your deployments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/update-deployments) and [Volume claim templates > Updating the volume claim settings](/docs/deploy-manage/deploy/cloud-on-k8s/volume-claim-templates#k8s-volume-claim-templates-update).
  </applies-item>
</applies-switch>