﻿---
title: Troubleshoot Elasticsearch
description: This section helps you fix issues with Elasticsearch deployments. Fix common cluster issues, Cluster health API. Watermark errors, Add a preferred data...
url: https://www.elastic.co/docs/troubleshoot/elasticsearch
products:
  - Elasticsearch
---

# Troubleshoot Elasticsearch
This section helps you fix issues with Elasticsearch deployments.
<admonition title="Simplify monitoring with AutoOps">
  AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths. Learn more about [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops).
</admonition>


## General

- [Fix common cluster issues](https://www.elastic.co/docs/troubleshoot/elasticsearch/fix-common-cluster-issues)
- [Cluster health API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-health_report)


## Data

- [Watermark errors](https://www.elastic.co/docs/troubleshoot/elasticsearch/fix-watermark-errors)
- [Add a preferred data tier to a deployment](https://www.elastic.co/docs/troubleshoot/elasticsearch/add-tier)
- [Allow Elasticsearch to allocate the data in the system](https://www.elastic.co/docs/troubleshoot/elasticsearch/allow-all-cluster-allocation)
- [Allow Elasticsearch to allocate the index](https://www.elastic.co/docs/troubleshoot/elasticsearch/allow-all-index-allocation)
- [Troubleshoot incomplete migration to data tiers](https://www.elastic.co/docs/troubleshoot/elasticsearch/troubleshoot-migrate-to-tiers)
- [Warning: Not enough nodes to allocate all shard replicas](https://www.elastic.co/docs/troubleshoot/elasticsearch/increase-tier-capacity)
- [Total number of shards for an index on a single node exceeded](https://www.elastic.co/docs/troubleshoot/elasticsearch/increase-shard-limit)
- [Total number of shards per node has been reached](https://www.elastic.co/docs/troubleshoot/elasticsearch/increase-cluster-shard-limit)
- [Troubleshoot data corruption](https://www.elastic.co/docs/troubleshoot/elasticsearch/corruption-troubleshooting)
- [Troubleshoot Ingest pipelines](https://www.elastic.co/docs/troubleshoot/elasticsearch/troubleshoot-ingest-pipelines)


## Management

- [Troubleshoot snapshot and index lifecycle management](https://www.elastic.co/docs/troubleshoot/elasticsearch/start-ilm)
- [Fix index lifecycle management errors](https://www.elastic.co/docs/troubleshoot/elasticsearch/index-lifecycle-management-errors)
- [File-based access recovery](https://www.elastic.co/docs/troubleshoot/elasticsearch/file-based-recovery)


## Capacity

- [Fix data nodes out of disk](https://www.elastic.co/docs/troubleshoot/elasticsearch/fix-data-node-out-of-disk)
- [Fix master nodes out of disk](https://www.elastic.co/docs/troubleshoot/elasticsearch/fix-master-node-out-of-disk)
- [Fix other role nodes out of disk](https://www.elastic.co/docs/troubleshoot/elasticsearch/fix-other-node-out-of-disk)


## Snapshot and restore

- [Restore from snapshot](https://www.elastic.co/docs/troubleshoot/elasticsearch/restore-from-snapshot)
- [Troubleshoot broken repositories](https://www.elastic.co/docs/troubleshoot/elasticsearch/add-repository)
- [Fix repeated snapshot policy failures](https://www.elastic.co/docs/troubleshoot/elasticsearch/repeated-snapshot-failures)


## Other issues

- [Troubleshoot an unstable cluster](https://www.elastic.co/docs/troubleshoot/elasticsearch/troubleshooting-unstable-cluster)
- [Troubleshoot using the cluster allocation API](https://www.elastic.co/docs/troubleshoot/elasticsearch/cluster-allocation-api-examples)
- [Troubleshoot discovery](https://www.elastic.co/docs/troubleshoot/elasticsearch/discovery-troubleshooting)
- [Troubleshoot monitoring](https://www.elastic.co/docs/troubleshoot/elasticsearch/monitoring-troubleshooting)
- [Troubleshoot transforms](https://www.elastic.co/docs/troubleshoot/elasticsearch/transform-troubleshooting)
- [Troubleshoot Watcher](https://www.elastic.co/docs/troubleshoot/elasticsearch/watcher-troubleshooting)
- [Troubleshoot searches](https://www.elastic.co/docs/troubleshoot/elasticsearch/troubleshooting-searches)
- [Troubleshoot shard capacity health issues](https://www.elastic.co/docs/troubleshoot/elasticsearch/troubleshooting-shards-capacity-issues)
- [Troubleshoot an unbalanced cluster](https://www.elastic.co/docs/troubleshoot/elasticsearch/troubleshooting-unbalanced-cluster)
- [Troubleshoot remote clusters](https://www.elastic.co/docs/troubleshoot/elasticsearch/remote-clusters)


## Additional resources

If you can't find your issue here, check the [troubleshooting overview](https://www.elastic.co/docs/troubleshoot) or [contact us](/docs/troubleshoot#contact-us).