﻿---
title: Troubleshoot Elastic Cloud SSO
description: Double check the saml_idp.sso_url provided during IdP registration. This should be the HTTP-POST binding URL to your IdP’s SAML application. Elastic Cloud...
url: https://www.elastic.co/docs/troubleshoot/deployments/elastic-cloud/sso
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Troubleshoot Elastic Cloud SSO
## SSO screen is not redirecting to my IdP

Double check the `saml_idp.sso_url` provided during IdP registration. This should be the HTTP-POST binding URL to your IdP’s SAML application. Elastic Cloud will redirect to this URL during sign in.

## Failure to redirect back to Elastic Cloud after IdP log in, or redirected to `/access-denied`

There could be a variety of issues that might result in sign in failure. Try tracing the SAML request and response with a SAML tracer. You should see a `SAMLRequest` field when redirecting to your IdP, and a `SAMLResponse` field when redirecting to the Cloud ACS.
If there was an error in your IdP, there may be a non-success `Status` field which should describe the error that occurred.
If the SAML response was successful, double-check the components of the SAML response:
- The `Destination` and `Recipient` should match the `acs` provided by the Elastic Cloud IdP registration API.
- An `AttributeStatement` named `email` should be sent with the email matching a domain claimed by your Elastic Cloud organization. If the domain of the email doesn’t match a claimed domain, the authentication flow will not complete.
- The `AudienceRestriction` `Audience` should match the `sp_entity_id` provided by the Elastic Cloud IdP registration API.
- The `Issuer` should match the value provided to the Elastic Cloud IdP registration API.
- The signature of the SAML response should be verifiable by the certificate provided during IdP configuration in Cloud.