﻿---
title: Troubleshoot Elastic Cloud
description: Use the topics in this section to troubleshoot Elastic Cloud: Troubleshoot Elastic Cloud SSO, Diagnose unavailable nodes, Diagnose unavailable shards,...
url: https://www.elastic.co/docs/troubleshoot/deployments/elastic-cloud
products:
  - Elastic Cloud Hosted
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Troubleshoot Elastic Cloud
Use the topics in this section to troubleshoot Elastic Cloud:
- [Troubleshoot Elastic Cloud SSO](https://www.elastic.co/docs/troubleshoot/deployments/elastic-cloud/sso)
- [Diagnose unavailable nodes](https://www.elastic.co/docs/troubleshoot/monitoring/unavailable-nodes)
- [Diagnose unavailable shards](https://www.elastic.co/docs/troubleshoot/monitoring/unavailable-shards)
- [Troubleshoot performance degrading over time](https://www.elastic.co/docs/troubleshoot/monitoring/performance)
- [Troubleshoot high memory pressure](https://www.elastic.co/docs/troubleshoot/monitoring/high-memory-pressure)
- [Troubleshoot cluster availability using performance metrics](https://www.elastic.co/docs/troubleshoot/monitoring/high-availability)
- [Troubleshoot slow cluster response time](https://www.elastic.co/docs/troubleshoot/monitoring/cluster-response-time)
- [Understanding node moves and system maintenance](https://www.elastic.co/docs/troubleshoot/monitoring/node-moves-outages)
- [Troubleshoot deployment health warnings on Elastic Cloud Hosted](https://www.elastic.co/docs/troubleshoot/monitoring/deployment-health-warnings)
- [Troubleshoot node bootlooping in Elastic Cloud Hosted](https://www.elastic.co/docs/troubleshoot/monitoring/node-bootlooping)

<admonition title="Simplify monitoring with AutoOps">
  AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths. Learn more about [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops).
</admonition>