﻿---
title: Troubleshoot Elastic Cloud on Kubernetes
description: This section provides information on the following topics: Common issues, Troubleshooting resources and logs, Running diagnostics, JVM heap dumps. If...
url: https://www.elastic.co/docs/troubleshoot/deployments/cloud-on-k8s/kubernetes
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Troubleshoot Elastic Cloud on Kubernetes
This section provides information on the following topics:
- [Common issues](https://www.elastic.co/docs/troubleshoot/deployments/cloud-on-k8s/common-problems)
- [Troubleshooting resources and logs](https://www.elastic.co/docs/troubleshoot/deployments/cloud-on-k8s/troubleshooting-methods)
- [Running diagnostics](https://www.elastic.co/docs/troubleshoot/deployments/cloud-on-k8s/run-eck-diagnostics)
- [JVM heap dumps](https://www.elastic.co/docs/troubleshoot/deployments/cloud-on-k8s/jvm-heap-dumps)

If you are an existing Elastic customer with an active support contract, you can create a case in the [Elastic Support Portal](https://support.elastic.co/). Kindly attach an [ECK diagnostic](https://www.elastic.co/docs/troubleshoot/deployments/cloud-on-k8s/run-eck-diagnostics) when opening your case.
Alternatively, or if you do not have a support contract, and if you are unable to find a solution to your problem with the information provided in these documents, ask for help:
- [ECK Discuss forums](https://discuss.elastic.co/c/eck) to ask any question
- [Github issues](https://github.com/elastic/cloud-on-k8s/issues) for bugs and feature requests

<admonition title="Simplify monitoring with AutoOps">
  AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths. Learn more about [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops).
</admonition>