﻿---
title: Troubleshoot container engines
description: This article describes how to troubleshoot container engine services in Elastic Cloud Enterprise. We refer to Docker by default, as it’s the most common...
url: https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/troubleshooting-container-engines
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Troubleshoot container engines
This article describes how to troubleshoot container engine services in Elastic Cloud Enterprise. We refer to [Docker](https://www.docker.com/) by default, as it’s the most common container engine, but these steps are also valid for [Podman](https://podman.io/). You can simply replace `docker` in the commands  with `podman` as needed.
<important>
  Do not restart the Docker daemon unless directly prescribed by Elastic Support upon reviewing an [Elastic Cloud Enterprise diagnostic](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/run-ece-diagnostics-tool), as historically Docker can leave residual orphan processes. We also advise against running any variation of Docker’s `prune` to avoid accidental data loss.
</important>


## Use supported configuration

Make sure to use a combination of [Linux operating systems](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-operating-system) and container engine version that is supported, following our official [Support matrix](https://www.elastic.co/support/matrix#elastic-cloud-enterprise). Using unsupported combinations can cause a plethora of either intermediate or potentially permanent issues with you Elastic Cloud Enterprise environment, such as failures to create [system deployments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/system-deployments-configuration), to upgrade workload deployments, proxy timeouts, data loss, and more.

## Troubleshoot unhealthy containers

While troubleshooting the stability of an Elastic Cloud Enterprise host, you may encounter `unhealthy` Docker containers as reported by [`ps`](https://docs.docker.com/reference/cli/docker/container/ls).
System containers reporting unhealthy is infrequent and usually only occurs after an unexpected occurance or issues while performing operating system maintenance. If operating system maintenance does need performed, kindly pivot to our [perform host maintenance guide](https://www.elastic.co/docs/deploy-manage/maintenance/ece/perform-ece-hosts-maintenance).

### Restart deployment instances

If the `unhealthy` Docker container is a Deployment’s instance, name formatting `fac-{{cluster_id}}-instance-{{node_id}}`, we recommend restarting the instance from the Elastic Cloud Enterprise UI via [its pause and resume mechanism](https://www.elastic.co/docs/deploy-manage/maintenance/ece/deployments-maintenance) rather than via Docker.
If the `unhealthy` status returns, we recommend investigating via [our troubleshooting bootlooping guide](https://www.elastic.co/docs/troubleshoot/monitoring/node-bootlooping).
This should indicate an issue with the Elasticsearch configuration rather than any Docker-level problem. An isolated exception effecting [air-gapped environments](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/air-gapped-install) is if the expected Docker [`image`](https://docs.docker.com/reference/cli/docker/image/ls/) does not yet exist on the Allocator in which case its logs would report `Unable to pull image`.

### Restart service containers

While troubleshooting `unhealthy` Elastic Cloud Enterprise system containers (name prefix `frc-`), *some* may be restarted while others should not.
Elastic Cloud Enterprise's [runners](https://www.elastic.co/docs/api/doc/cloud-enterprise/operation/operation-get-runners) will automatically create or restart missing system containers. If you’re attempting to permanently remove a system container by removing its role from the host, you’d instead [update runner roles](https://www.elastic.co/docs/api/doc/cloud-enterprise/operation/operation-set-runner-roles). If eligible system containers return to an `unhealthy` status after restart, we recommend reviewing their start-up Docker [`logs`](https://docs.docker.com/reference/cli/docker/container/logs/).
It is safe to restart the following via Docker [`stop`](https://docs.docker.com/reference/cli/docker/container/stop/) followed by Docker [`rm`](https://docs.docker.com/reference/cli/docker/container/rm/) on:
- `frc-allocator-metricbeats-allocator-metricbeat`
- `frc-allocators-allocator`
- `frc-beats-runners-beats-runner`
- `frc-constructors-constructor`
- `frc-proxies-proxyv2`
- `frc-proxies-route-server`

It is safe to restart the following via Docker [`restart`](https://docs.docker.com/reference/cli/docker/container/restart/):
- `frc-client-forwarders-client-forwarder`
- `frc-directors-director`
- `frc-services-forwarders-services-forwarder`

It is **not** safe to restart the following without explicit steps from Elastic Support upon reviewing an [Elastic Cloud Enterprise diagnostic](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/run-ece-diagnostics-tool):
- any container name prefixing `fac-`
- `frc-runners-runner`
- `frc-zookeeper-servers-zookeeper`

For unhealthy Zookeeper, instead see [verify Zookeeper sync status](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/verify-zookeeper-sync-status) and [resolving Zookeeper quorum](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/rebuilding-broken-zookeeper-quorum).
For any Elastic Cloud Enterprise system container not listed, reach out to [Elastic Support](/docs/troubleshoot#contact-us).