﻿---
title: Troubleshoot deployment health warnings on Elastic Cloud Enterprise
description: The Elastic Cloud Enterprise Deployments page shows the current status of your active deployments. From time to time you may get one or more health warnings,...
url: https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/deployment-health-warnings
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Troubleshoot deployment health warnings on Elastic Cloud Enterprise
The Elastic Cloud Enterprise **Deployments** page shows the current status of your active deployments. From time to time you may get one or more health warnings, such as the following:
![A screen capture of the deployment page showing a typical warning: Deployment health warning: Latest change to Elasticsearch configuration failed.](https://www.elastic.co/docs/troubleshoot/images/cloud-ec-ce-deployment-health-warning.png)

**Single warning**
To resolve a single health warning, we recommended first running a _no-op_ (no operation) plan. This performs a rolling update on the components in your Elastic Cloud Enterprise deployment without actually applying any configuration changes. This is often all that’s needed to resolve a health warning on the UI.
To run a no-op plan:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. Select a deployment.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
3. From your deployment menu, go to the **Edit** page.
4. Select **Save**.

**Multiple warnings**
If multiple health warnings appear for one of your deployments, check [Common problems with Elastic Cloud Enterprise](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/common-issues) or [contact us](/docs/troubleshoot#contact-us).
<admonition title="Simplify monitoring with AutoOps">
  AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths. Learn more about [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops).
</admonition>


## Additional resources

- [Troubleshoot deployment health warnings on Elastic Cloud Hosted](https://www.elastic.co/docs/troubleshoot/monitoring/deployment-health-warnings)
- [Troubleshooting overview](https://www.elastic.co/docs/troubleshoot)