﻿---
title: Elastic Security feature tiers
description: Elastic Security Serverless projects are available in the following tiers, each with a carefully selected set of features to enable security operations:...
url: https://www.elastic.co/docs/solutions/security/security-serverless-feature-tiers
products:
  - Elastic Security
applies_to:
  - Elastic Cloud Serverless: Generally available
---

# Elastic Security feature tiers
Elastic Security Serverless projects are available in the following tiers, each with a carefully selected set of features to enable security operations:
- **Elastic AI SOC Engine (EASE)**: Use Elastic's AI-powered threat hunting and alert triage capabilities to complement a third-party SIEM deployment.
- **Security Analytics Essentials**: Everything most organizations need to operationalize traditional SIEM.
- **Security Analytics Complete**: All the capabilities included in **Security Analytics Essentials**, plus additional features that provide a more complete toolset.

Both of the **Security Analytics** tiers have **Add-on options** for endpoint protection and cloud protection.
Refer to the [feature comparison table](#sec-subscription-features) for a more detailed comparison between the tiers.

## Feature tier pricing

For pricing information, refer to [Elastic Security Serverless pricing](https://www.elastic.co/pricing/serverless-security).

## Security Analytics feature comparison

The following table compares features available in each feature tier:

| **Feature Name**                                                                                                                                                                                                                                  | **Security Analytics Complete** | **Security Analytics Essentials** | **EASE** |
|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------|-----------------------------------|----------|
| **[Cases](https://www.elastic.co/docs/solutions/security/investigate/cases) (collect and share information)**                                                                                                                                     | ✅                               | ✅                                 | ✅        |
| **[Native integrations](https://www.elastic.co/docs/reference/integrations) with third-party SIEM and EDR platforms**                                                                                                                             | ✅                               | ✅                                 | ✅        |
| **Out of the box [dashboards](https://www.elastic.co/docs/solutions/security/dashboards)**                                                                                                                                                        | ✅                               | ✅                                 | ❌        |
| **Prebuilt and custom [detection rules](https://www.elastic.co/docs/solutions/security/detect-and-alert)**                                                                                                                                        | ✅                               | ✅                                 | ❌        |
| **[Machine learning](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/anomaly-detection)**                                                                                                                                | ✅                               | ✅                                 | ❌        |
| **[Triage](https://www.elastic.co/docs/solutions/security/detect-and-alert/manage-detection-alerts), [investigation](https://www.elastic.co/docs/solutions/security/investigate), and [hunting](https://www.elastic.co/security/threat-hunting)** | ✅                               | ✅                                 | ❌        |
| **[Threat intelligence integration](https://www.elastic.co/docs/solutions/security/get-started/enable-threat-intelligence-integrations)**                                                                                                         | ✅                               | ✅                                 | ❌        |
| **[AI Assistant](https://www.elastic.co/docs/solutions/security/ai/ai-assistant) with custom knowledge support**                                                                                                                                  | ✅                               | ❌                                 | ✅        |
| **[Attack Discovery](https://www.elastic.co/docs/solutions/security/ai/attack-discovery) (AI-powered alert correlation)**                                                                                                                         | ✅                               | ❌                                 | ✅        |
| **[Automatic Import](https://www.elastic.co/docs/solutions/security/get-started/automatic-import) (AI-powered custom integrations)**                                                                                                              | ✅                               | ❌                                 | ❌        |
| **[Entity analytics / UEBA](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics)**                                                                                                                                           | ✅                               | ❌                                 | ❌        |
| **Extended security content**                                                                                                                                                                                                                     | ✅                               | ❌                                 | ❌        |
| **Threat intelligence management**                                                                                                                                                                                                                | ✅                               | ❌                                 | ❌        |


## Add-on options

Both the **Security Analytics Complete** and **Security Analytics Essentials** feature tiers have optional add-ons for **Endpoint protection** and **Cloud protection**. The features included in each add on vary by feature tier, as follows:
**Endpoint protection add-on:**

| Feature Name                                                                                                                                                                                                                                                                             | Complete | Essentials |
|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|------------|
| **[Malware prevention](/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend#malware-protection)**                                                                                                                                        | ✅        | ✅          |
| **[Ransomware protection](/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend#ransomware-protection)**                                                                                                                                  | ✅        | ✅          |
| **[Memory](/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend#memory-protection) and [behavior prevention](/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend#behavior-protection)** | ✅        | ✅          |
| **[Endpoint response actions](https://www.elastic.co/docs/solutions/security/endpoint-response-actions)**                                                                                                                                                                                | ✅        | ❌          |
| **Advanced [endpoint policy management](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/endpoints)**                                                                                                                                                                | ✅        | ❌          |

**Cloud protection add-on:**

| Feature Name                                                                                                                                                     | Complete | Essentials |
|------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|------------|
| **[Workload runtime protection](https://www.elastic.co/docs/solutions/security/cloud/cloud-workload-protection-for-vms)**                                        | ✅        | ✅          |
| **[Cloud native posture management](https://www.elastic.co/docs/solutions/security/cloud/security-posture-management-overview) for Kubernetes, AWS, GCP & more** | ✅        | ✅          |
| **[Response actions](https://www.elastic.co/docs/solutions/security/endpoint-response-actions)**                                                                 | ✅        | ❌          |


## Upgrade to a higher feature tier

<warning>
  Upgrading a project to a higher feature tier cannot always be efficiently reversed: downgrading to a lower tier immediately makes some features unavailable, and data associated with those features can be permanently deleted.
</warning>

To access the additional features available in a higher feature tier:
1. From the [Elastic Cloud Console](https://cloud.elastic.co), select **Manage** next to the Serverless project you want to upgrade.
2. Next to **Project features**, select **Edit**.
3. Select your desired feature tier.
4. Select **Save** to complete the upgrade.