﻿---
title: Trusted devices
description: By default, Elastic Defend policies have device control enabled, with access level set to block all operations. This prevents external storage devices...
url: https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-devices
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Trusted devices
By default, Elastic Defend policies have [device control](/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend#device-control) enabled, with access level set to block all operations. This prevents external storage devices from connecting to protected hosts.
<important>
  - Device control only affects external USB storage devices. It does not affect other peripherals such as Yubikeys, webcams, or keyboards.
  - Device control only supports Windows and Mac endpoints.
</important>

Trusted devices are specific external devices that are allowed to connect to your protected hosts regardless of device control settings. Create trusted devices to avoid interfering with expected workflows that involve known hardware.
By default, a trusted device is recognized globally across all hosts running Elastic Defend. You can also assign a trusted device to a specific Elastic Defend integration policy, enabling the device to be trusted by only the hosts assigned to that policy.

## Add a trusted device

Add a trusted device to exempt it from device control:
1. Go to the **Trusted Devices** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **+ Add trusted device**. The Add trusted device flyout opens.
3. Name your trusted device and give it a description.
4. In the **Conditions** section, specify the operating system(s) and the `Device ID`.
5. Select an option in the **Assignment** section:
   - **Global**: Assign the trusted device to all Elastic Defend integration policies.
- **Per Policy**: Assign the trusted device to one or more specific Elastic Defend integration policies.
6. Click **Add trusted device**.


## View and manage trusted devices

The **Trusted devices** page displays all the trusted devices that have been added to the Elastic Security app. To refine the list, use the search bar to search by name, description, or field value.
![trusted apps list](https://www.elastic.co/docs/solutions/images/security-trusted-devices-list.png)


### Edit a trusted device

You can individually modify each trusted device. You can also change the policies that a trusted device is assigned to.
To edit a trusted device:
1. Click the actions menu (**…**) on the trusted device you want to edit, then select **Edit trusted device**.
2. Modify details as needed.
3. Click **Save**.


### Delete a trusted device

You can delete a trusted device, which removes it entirely from all Elastic Defend integration policies.
To delete a trusted device:
1. Click the actions menu (**…**) on the trusted device you want to delete, then select **Delete trusted device**.
2. On the dialog that opens, verify that you are removing the correct device, then click **Delete**. A confirmation message appears.