﻿---
title: Optimize Elastic Defend
description: If you encounter problems like incompatibilities with other antivirus software, too many false positive alerts, or excessive storage or CPU usage, you...
url: https://www.elastic.co/docs/solutions/security/manage-elastic-defend/optimize-elastic-defend
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Optimize Elastic Defend
If you encounter problems like incompatibilities with other antivirus software, too many false positive alerts, or excessive storage or CPU usage, you can optimize Elastic Defend to mitigate these issues.
Endpoint artifacts — such as trusted applications and event filters — and Endpoint exceptions let you modify the behavior and performance of *Elastic Endpoint*, the component installed on each host that performs Elastic Defend's threat monitoring, prevention, and response actions.
The following table explains the differences between several Endpoint artifacts and exceptions, and how to use them:

|                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Trusted application](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-applications)     | **Prevents Elastic Endpoint from monitoring a process.** Use to avoid conflicts with other software, usually other antivirus or endpoint security applications. - Creates intentional blind spots in your security environment — use sparingly!- Stops direct threat analysis on the application's file, meaning its signature and code will not be scanned for known malware threats upon execution.- Doesn’t generate events for the application except process events for visualizations and other internal use by the Elastic Stack.- Might improve performance, since Elastic Endpoint monitors fewer processes.- While the application file itself is not scanned, its actions are still monitored as part of the overall system activity. Our separate behavioral detection engine will still generate an alert if the trusted application performs a sequence of actions that matches a malicious pattern, such as ransomware-like file encryption. To suppress alerts, create [Endpoint alert exceptions](/docs/solutions/security/detect-and-alert/add-manage-exceptions#endpoint-rule-exceptions). |
| [Event filter](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/event-filters)                   | **Prevents event documents from being written to Elasticsearch.** Use to reduce storage usage in Elasticsearch.Does NOT lower CPU usage for Elastic Endpoint. It still monitors event data for possible threats, but without writing event data to Elasticsearch.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [Blocklist](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/blocklist)                          | **Prevents known malware from running.** Use to extend Elastic Defend's protection against malicious processes.NOT intended to broadly block benign applications for non-security reasons.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [Endpoint alert exception](/docs/solutions/security/detect-and-alert/add-manage-exceptions#endpoint-rule-exceptions) | **Prevents Elastic Endpoint from generating alerts or stopping processes.** Use to reduce false positive alerts, and to keep Elastic Endpoint from preventing processes you want to allow.Might also improve performance: Elastic Endpoint checks for exceptions *before* most other processing, and stops monitoring a process if an exception allows it.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |